// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to terminate an environment.
 */
class TerminateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The ID of the environment to terminate.
     * Condition: You must specify either this or an EnvironmentName, or both. If you do not
     * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
     */
    val environmentId: kotlin.String? = builder.environmentId
    /**
     * The name of the environment to terminate.
     * Condition: You must specify either this or an EnvironmentId, or both. If you do not
     * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * Terminates the target environment even if another environment in the same group is
     * dependent on it.
     */
    val forceTerminate: kotlin.Boolean? = builder.forceTerminate
    /**
     * Indicates whether the associated AWS resources should shut down when the environment is
     * terminated:
     * true: The specified environment as well as the associated AWS resources, such
     * as Auto Scaling group and LoadBalancer, are terminated.
     * false: AWS Elastic Beanstalk resource management is removed from the
     * environment, but the AWS resources continue to operate.
     * For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide.
     * Default: true
     * Valid Values: true | false
     */
    val terminateResources: kotlin.Boolean? = builder.terminateResources

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TerminateEnvironmentRequest(")
        append("environmentId=$environmentId,")
        append("environmentName=$environmentName,")
        append("forceTerminate=$forceTerminate,")
        append("terminateResources=$terminateResources)")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (forceTerminate?.hashCode() ?: 0)
        result = 31 * result + (terminateResources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TerminateEnvironmentRequest

        if (environmentId != other.environmentId) return false
        if (environmentName != other.environmentName) return false
        if (forceTerminate != other.forceTerminate) return false
        if (terminateResources != other.terminateResources) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the environment to terminate.
         * Condition: You must specify either this or an EnvironmentName, or both. If you do not
         * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
         */
        var environmentId: kotlin.String? = null
        /**
         * The name of the environment to terminate.
         * Condition: You must specify either this or an EnvironmentId, or both. If you do not
         * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
         */
        var environmentName: kotlin.String? = null
        /**
         * Terminates the target environment even if another environment in the same group is
         * dependent on it.
         */
        var forceTerminate: kotlin.Boolean? = null
        /**
         * Indicates whether the associated AWS resources should shut down when the environment is
         * terminated:
         * true: The specified environment as well as the associated AWS resources, such
         * as Auto Scaling group and LoadBalancer, are terminated.
         * false: AWS Elastic Beanstalk resource management is removed from the
         * environment, but the AWS resources continue to operate.
         * For more information, see the <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/"> AWS Elastic Beanstalk User Guide.
         * Default: true
         * Valid Values: true | false
         */
        var terminateResources: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentRequest) : this() {
            this.environmentId = x.environmentId
            this.environmentName = x.environmentName
            this.forceTerminate = x.forceTerminate
            this.terminateResources = x.terminateResources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentRequest = TerminateEnvironmentRequest(this)
    }
}
