// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Describes criteria to restrict a list of results.
 * For operators that apply a single value to the attribute, the filter is evaluated as
 * follows: Attribute Operator Values&#91;1&#93;
 * Some operators, e.g. in, can apply multiple values. In this case, the filter
 * is evaluated as a logical union (OR) of applications of the operator to the attribute with
 * each one of the values: (Attribute Operator Values&#91;1&#93;) OR (Attribute Operator Values&#91;2&#93;)
 * OR ...
 * The valid values for attributes of SearchFilter depend on the API action. For
 * valid values, see the reference page for the API action you're calling that takes a
 * SearchFilter parameter.
 */
class SearchFilter private constructor(builder: Builder) {
    /**
     * The result attribute to which the filter values are applied. Valid values vary by API
     * action.
     */
    val attribute: kotlin.String? = builder.attribute
    /**
     * The operator to apply to the Attribute with each of the Values.
     * Valid values vary by Attribute.
     */
    val operator: kotlin.String? = builder.operator
    /**
     * The list of values applied to the Attribute and Operator
     * attributes. Number of values and valid values vary by Attribute.
     */
    val values: List<String>? = builder.values

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchFilter(")
        append("attribute=$attribute,")
        append("operator=$operator,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as SearchFilter

        if (attribute != other.attribute) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The result attribute to which the filter values are applied. Valid values vary by API
         * action.
         */
        var attribute: kotlin.String? = null
        /**
         * The operator to apply to the Attribute with each of the Values.
         * Valid values vary by Attribute.
         */
        var operator: kotlin.String? = null
        /**
         * The list of values applied to the Attribute and Operator
         * attributes. Number of values and valid values vary by Attribute.
         */
        var values: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter) : this() {
            this.attribute = x.attribute
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = SearchFilter(this)
    }
}
