// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to retrieve logs from an environment and store them in your Elastic Beanstalk
 * storage bucket.
 */
class RequestEnvironmentInfoRequest private constructor(builder: Builder) {
    /**
     * The ID of the environment of the requested data.
     * If no such environment is found, RequestEnvironmentInfo returns an
     * InvalidParameterValue error.
     * Condition: You must specify either this or an EnvironmentName, or both. If you do not
     * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
     */
    val environmentId: kotlin.String? = builder.environmentId
    /**
     * The name of the environment of the requested data.
     * If no such environment is found, RequestEnvironmentInfo returns an
     * InvalidParameterValue error.
     * Condition: You must specify either this or an EnvironmentId, or both. If you do not
     * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * The type of information to request.
     */
    val infoType: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoType? = builder.infoType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestEnvironmentInfoRequest(")
        append("environmentId=$environmentId,")
        append("environmentName=$environmentName,")
        append("infoType=$infoType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = environmentId?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (infoType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as RequestEnvironmentInfoRequest

        if (environmentId != other.environmentId) return false
        if (environmentName != other.environmentName) return false
        if (infoType != other.infoType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the environment of the requested data.
         * If no such environment is found, RequestEnvironmentInfo returns an
         * InvalidParameterValue error.
         * Condition: You must specify either this or an EnvironmentName, or both. If you do not
         * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
         */
        var environmentId: kotlin.String? = null
        /**
         * The name of the environment of the requested data.
         * If no such environment is found, RequestEnvironmentInfo returns an
         * InvalidParameterValue error.
         * Condition: You must specify either this or an EnvironmentId, or both. If you do not
         * specify either, AWS Elastic Beanstalk returns MissingRequiredParameter error.
         */
        var environmentName: kotlin.String? = null
        /**
         * The type of information to request.
         */
        var infoType: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest) : this() {
            this.environmentId = x.environmentId
            this.environmentName = x.environmentName
            this.infoType = x.infoType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest = RequestEnvironmentInfoRequest(this)
    }
}
