// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Represents summary information about the health of an instance. For more information,
 * see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html">Health Colors and Statuses.
 */
class InstanceHealthSummary private constructor(builder: Builder) {
    /**
     * Red. The health agent is reporting a high number of request
     * failures or other issues for an instance or environment.
     */
    val degraded: kotlin.Int? = builder.degraded
    /**
     * Green. An operation is in progress on an instance.
     */
    val info: kotlin.Int? = builder.info
    /**
     * Grey. AWS Elastic Beanstalk and the health agent are
     * reporting no data on an instance.
     */
    val noData: kotlin.Int? = builder.noData
    /**
     * Green. An instance is passing health checks and the health
     * agent is not reporting any problems.
     */
    val ok: kotlin.Int? = builder.ok
    /**
     * Grey. An operation is in progress on an instance within the
     * command timeout.
     */
    val pending: kotlin.Int? = builder.pending
    /**
     * Red. The health agent is reporting a very high number of
     * request failures or other issues for an instance or environment.
     */
    val severe: kotlin.Int? = builder.severe
    /**
     * Grey. AWS Elastic Beanstalk and the health agent are
     * reporting an insufficient amount of data on an instance.
     */
    val unknown: kotlin.Int? = builder.unknown
    /**
     * Yellow. The health agent is reporting a moderate number of
     * request failures or other issues for an instance or environment.
     */
    val warning: kotlin.Int? = builder.warning

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceHealthSummary(")
        append("degraded=$degraded,")
        append("info=$info,")
        append("noData=$noData,")
        append("ok=$ok,")
        append("pending=$pending,")
        append("severe=$severe,")
        append("unknown=$unknown,")
        append("warning=$warning)")
    }

    override fun hashCode(): kotlin.Int {
        var result = degraded ?: 0
        result = 31 * result + (info ?: 0)
        result = 31 * result + (noData ?: 0)
        result = 31 * result + (ok ?: 0)
        result = 31 * result + (pending ?: 0)
        result = 31 * result + (severe ?: 0)
        result = 31 * result + (unknown ?: 0)
        result = 31 * result + (warning ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as InstanceHealthSummary

        if (degraded != other.degraded) return false
        if (info != other.info) return false
        if (noData != other.noData) return false
        if (ok != other.ok) return false
        if (pending != other.pending) return false
        if (severe != other.severe) return false
        if (unknown != other.unknown) return false
        if (warning != other.warning) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary = Builder(this).apply(block).build()

    class Builder {
        /**
         * Red. The health agent is reporting a high number of request
         * failures or other issues for an instance or environment.
         */
        var degraded: kotlin.Int? = null
        /**
         * Green. An operation is in progress on an instance.
         */
        var info: kotlin.Int? = null
        /**
         * Grey. AWS Elastic Beanstalk and the health agent are
         * reporting no data on an instance.
         */
        var noData: kotlin.Int? = null
        /**
         * Green. An instance is passing health checks and the health
         * agent is not reporting any problems.
         */
        var ok: kotlin.Int? = null
        /**
         * Grey. An operation is in progress on an instance within the
         * command timeout.
         */
        var pending: kotlin.Int? = null
        /**
         * Red. The health agent is reporting a very high number of
         * request failures or other issues for an instance or environment.
         */
        var severe: kotlin.Int? = null
        /**
         * Grey. AWS Elastic Beanstalk and the health agent are
         * reporting an insufficient amount of data on an instance.
         */
        var unknown: kotlin.Int? = null
        /**
         * Yellow. The health agent is reporting a moderate number of
         * request failures or other issues for an instance or environment.
         */
        var warning: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary) : this() {
            this.degraded = x.degraded
            this.info = x.info
            this.noData = x.noData
            this.ok = x.ok
            this.pending = x.pending
            this.severe = x.severe
            this.unknown = x.unknown
            this.warning = x.warning
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary = InstanceHealthSummary(this)
    }
}
