// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The information retrieved from the Amazon EC2 instances.
 */
class EnvironmentInfoDescription private constructor(builder: Builder) {
    /**
     * The Amazon EC2 Instance ID for this information.
     */
    val ec2InstanceId: kotlin.String? = builder.ec2InstanceId
    /**
     * The type of information retrieved.
     */
    val infoType: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoType? = builder.infoType
    /**
     * The retrieved information. Currently contains a presigned Amazon S3 URL. The files are
     * deleted after 15 minutes.
     * Anyone in possession of this URL can access the files before they are deleted. Make the
     * URL available only to trusted parties.
     */
    val message: kotlin.String? = builder.message
    /**
     * The time stamp when this information was retrieved.
     */
    val sampleTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.sampleTimestamp

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentInfoDescription(")
        append("ec2InstanceId=$ec2InstanceId,")
        append("infoType=$infoType,")
        append("message=$message,")
        append("sampleTimestamp=$sampleTimestamp)")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2InstanceId?.hashCode() ?: 0
        result = 31 * result + (infoType?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (sampleTimestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EnvironmentInfoDescription

        if (ec2InstanceId != other.ec2InstanceId) return false
        if (infoType != other.infoType) return false
        if (message != other.message) return false
        if (sampleTimestamp != other.sampleTimestamp) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon EC2 Instance ID for this information.
         */
        var ec2InstanceId: kotlin.String? = null
        /**
         * The type of information retrieved.
         */
        var infoType: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoType? = null
        /**
         * The retrieved information. Currently contains a presigned Amazon S3 URL. The files are
         * deleted after 15 minutes.
         * Anyone in possession of this URL can access the files before they are deleted. Make the
         * URL available only to trusted parties.
         */
        var message: kotlin.String? = null
        /**
         * The time stamp when this information was retrieved.
         */
        var sampleTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoDescription) : this() {
            this.ec2InstanceId = x.ec2InstanceId
            this.infoType = x.infoType
            this.message = x.message
            this.sampleTimestamp = x.sampleTimestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentInfoDescription = EnvironmentInfoDescription(this)
    }
}
