// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed health information about the Amazon EC2 instances in an AWS Elastic Beanstalk
 * environment.
 */
class DescribeInstancesHealthResponse private constructor(builder: Builder) {
    /**
     * Detailed health information about each instance.
     * The output differs slightly between Linux and Windows environments. There is a difference
     * in the members that are supported under the <CPUUtilization> type.
     */
    val instanceHealthList: List<SingleInstanceHealth>? = builder.instanceHealthList
    /**
     * Pagination token for the next page of results, if available.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The date and time that the health information was retrieved.
     */
    val refreshedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.refreshedAt

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstancesHealthResponse(")
        append("instanceHealthList=$instanceHealthList,")
        append("nextToken=$nextToken,")
        append("refreshedAt=$refreshedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceHealthList?.hashCode() ?: 0
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (refreshedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeInstancesHealthResponse

        if (instanceHealthList != other.instanceHealthList) return false
        if (nextToken != other.nextToken) return false
        if (refreshedAt != other.refreshedAt) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * Detailed health information about each instance.
         * The output differs slightly between Linux and Windows environments. There is a difference
         * in the members that are supported under the <CPUUtilization> type.
         */
        var instanceHealthList: List<SingleInstanceHealth>? = null
        /**
         * Pagination token for the next page of results, if available.
         */
        var nextToken: kotlin.String? = null
        /**
         * The date and time that the health information was retrieved.
         */
        var refreshedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthResponse) : this() {
            this.instanceHealthList = x.instanceHealthList
            this.nextToken = x.nextToken
            this.refreshedAt = x.refreshedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthResponse = DescribeInstancesHealthResponse(this)
    }
}
