// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Request to retrieve a list of events for an environment.
 */
class DescribeEventsRequest private constructor(builder: Builder) {
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
     * those associated with this application.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
     * occur up to, but not including, the EndTime.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
     * associated with this environment.
     */
    val environmentId: kotlin.String? = builder.environmentId
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
     * associated with this environment.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * Specifies the maximum number of events that can be returned, beginning with the most
     * recent event.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * Pagination token. If specified, the events return the next batch of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the
     * returned descriptions to those associated with this custom platform version.
     */
    val platformArn: kotlin.String? = builder.platformArn
    /**
     * If specified, AWS Elastic Beanstalk restricts the described events to include only
     * those associated with this request ID.
     */
    val requestId: kotlin.String? = builder.requestId
    /**
     * If specified, limits the events returned from this call to include only those with the
     * specified severity or higher.
     */
    val severity: aws.sdk.kotlin.services.elasticbeanstalk.model.EventSeverity? = builder.severity
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
     * occur on or after this time.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
     * are associated with this environment configuration.
     */
    val templateName: kotlin.String? = builder.templateName
    /**
     * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
     * associated with this application version.
     */
    val versionLabel: kotlin.String? = builder.versionLabel

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEventsRequest(")
        append("applicationName=$applicationName,")
        append("endTime=$endTime,")
        append("environmentId=$environmentId,")
        append("environmentName=$environmentName,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken,")
        append("platformArn=$platformArn,")
        append("requestId=$requestId,")
        append("severity=$severity,")
        append("startTime=$startTime,")
        append("templateName=$templateName,")
        append("versionLabel=$versionLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeEventsRequest

        if (applicationName != other.applicationName) return false
        if (endTime != other.endTime) return false
        if (environmentId != other.environmentId) return false
        if (environmentName != other.environmentName) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false
        if (platformArn != other.platformArn) return false
        if (requestId != other.requestId) return false
        if (severity != other.severity) return false
        if (startTime != other.startTime) return false
        if (templateName != other.templateName) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to include only
         * those associated with this application.
         */
        var applicationName: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
         * occur up to, but not including, the EndTime.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
         * associated with this environment.
         */
        var environmentId: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
         * associated with this environment.
         */
        var environmentName: kotlin.String? = null
        /**
         * Specifies the maximum number of events that can be returned, beginning with the most
         * recent event.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * Pagination token. If specified, the events return the next batch of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The ARN of a custom platform version. If specified, AWS Elastic Beanstalk restricts the
         * returned descriptions to those associated with this custom platform version.
         */
        var platformArn: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the described events to include only
         * those associated with this request ID.
         */
        var requestId: kotlin.String? = null
        /**
         * If specified, limits the events returned from this call to include only those with the
         * specified severity or higher.
         */
        var severity: aws.sdk.kotlin.services.elasticbeanstalk.model.EventSeverity? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
         * occur on or after this time.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those that
         * are associated with this environment configuration.
         */
        var templateName: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk restricts the returned descriptions to those
         * associated with this application version.
         */
        var versionLabel: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest) : this() {
            this.applicationName = x.applicationName
            this.endTime = x.endTime
            this.environmentId = x.environmentId
            this.environmentName = x.environmentName
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
            this.platformArn = x.platformArn
            this.requestId = x.requestId
            this.severity = x.severity
            this.startTime = x.startTime
            this.templateName = x.templateName
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest = DescribeEventsRequest(this)
    }
}
