// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Result message containing all of the configuration settings for a specified solution
 * stack or configuration template.
 */
class DescribeConfigurationSettingsRequest private constructor(builder: Builder) {
    /**
     * The application for the environment or configuration template.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the environment to describe.
     * Condition: You must specify either this or a TemplateName, but not both. If you
     * specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination error.
     * If you do not specify either, AWS Elastic Beanstalk returns
     * MissingRequiredParameter error.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * The name of the configuration template to describe.
     * Conditional: You must specify either this parameter or an EnvironmentName, but not
     * both. If you specify both, AWS Elastic Beanstalk returns an
     * InvalidParameterCombination error. If you do not specify either, AWS Elastic
     * Beanstalk returns a MissingRequiredParameter error.
     */
    val templateName: kotlin.String? = builder.templateName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeConfigurationSettingsRequest(")
        append("applicationName=$applicationName,")
        append("environmentName=$environmentName,")
        append("templateName=$templateName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeConfigurationSettingsRequest

        if (applicationName != other.applicationName) return false
        if (environmentName != other.environmentName) return false
        if (templateName != other.templateName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The application for the environment or configuration template.
         */
        var applicationName: kotlin.String? = null
        /**
         * The name of the environment to describe.
         * Condition: You must specify either this or a TemplateName, but not both. If you
         * specify both, AWS Elastic Beanstalk returns an InvalidParameterCombination error.
         * If you do not specify either, AWS Elastic Beanstalk returns
         * MissingRequiredParameter error.
         */
        var environmentName: kotlin.String? = null
        /**
         * The name of the configuration template to describe.
         * Conditional: You must specify either this parameter or an EnvironmentName, but not
         * both. If you specify both, AWS Elastic Beanstalk returns an
         * InvalidParameterCombination error. If you do not specify either, AWS Elastic
         * Beanstalk returns a MissingRequiredParameter error.
         */
        var templateName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest) : this() {
            this.applicationName = x.applicationName
            this.environmentName = x.environmentName
            this.templateName = x.templateName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest = DescribeConfigurationSettingsRequest(this)
    }
}
