// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to describe application versions.
 */
class DescribeApplicationVersionsRequest private constructor(builder: Builder) {
    /**
     * Specify an application name to show only application versions for that
     * application.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * For a paginated request. Specify a maximum number of application versions to include in
     * each response.
     * If no MaxRecords is specified, all available application versions are
     * retrieved in a single response.
     */
    val maxRecords: kotlin.Int? = builder.maxRecords
    /**
     * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
     * parameter values must be identical to the ones specified in the initial request.
     * If no NextToken is specified, the first page is retrieved.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * Specify a version label to show a specific application version.
     */
    val versionLabels: List<String>? = builder.versionLabels

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeApplicationVersionsRequest(")
        append("applicationName=$applicationName,")
        append("maxRecords=$maxRecords,")
        append("nextToken=$nextToken,")
        append("versionLabels=$versionLabels)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (maxRecords ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (versionLabels?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeApplicationVersionsRequest

        if (applicationName != other.applicationName) return false
        if (maxRecords != other.maxRecords) return false
        if (nextToken != other.nextToken) return false
        if (versionLabels != other.versionLabels) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify an application name to show only application versions for that
         * application.
         */
        var applicationName: kotlin.String? = null
        /**
         * For a paginated request. Specify a maximum number of application versions to include in
         * each response.
         * If no MaxRecords is specified, all available application versions are
         * retrieved in a single response.
         */
        var maxRecords: kotlin.Int? = null
        /**
         * For a paginated request. Specify a token from a previous response page to retrieve the next response page. All other
         * parameter values must be identical to the ones specified in the initial request.
         * If no NextToken is specified, the first page is retrieved.
         */
        var nextToken: kotlin.String? = null
        /**
         * Specify a version label to show a specific application version.
         */
        var versionLabels: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest) : this() {
            this.applicationName = x.applicationName
            this.maxRecords = x.maxRecords
            this.nextToken = x.nextToken
            this.versionLabels = x.versionLabels
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest = DescribeApplicationVersionsRequest(this)
    }
}
