// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 *
 */
class CreateEnvironmentRequest private constructor(builder: Builder) {
    /**
     * The name of the application that is associated with this environment.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * If specified, the environment attempts to use this value as the prefix for the CNAME in
     * your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by
     * appending a random alphanumeric string to the environment name.
     */
    val cnamePrefix: kotlin.String? = builder.cnamePrefix
    /**
     * Your description for this environment.
     */
    val description: kotlin.String? = builder.description
    /**
     * A unique name for the environment.
     * Constraint: Must be from 4 to 40 characters in length. The name can contain only
     * letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique
     * within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an
     * InvalidParameterValue error.
     * If you don't specify the CNAMEPrefix parameter, the environment name becomes part of
     * the CNAME, and therefore part of the visible URL for your application.
     */
    val environmentName: kotlin.String? = builder.environmentName
    /**
     * The name of the group to which the target environment belongs. Specify a group name
     * only if the environment's name is specified in an environment manifest and not with the
     * environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
     * (env.yaml) for details.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
     * operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream
     * services during this call and during subsequent calls acting on this environment. To specify
     * an operations role, you must have the iam:PassRole permission for the role. For
     * more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
     * AWS Elastic Beanstalk Developer Guide.
     */
    val operationsRole: kotlin.String? = builder.operationsRole
    /**
     * If specified, AWS Elastic Beanstalk sets the specified configuration options to the
     * requested value in the configuration set for the new environment. These override the values
     * obtained from the solution stack or the configuration template.
     */
    val optionSettings: List<ConfigurationOptionSetting>? = builder.optionSettings
    /**
     * A list of custom user-defined configuration options to remove from the configuration
     * set for this new environment.
     */
    val optionsToRemove: List<OptionSpecification>? = builder.optionsToRemove
    /**
     * The Amazon Resource Name (ARN) of the custom platform to use with the environment. For
     * more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms in the
     * AWS Elastic Beanstalk Developer Guide.
     * If you specify PlatformArn, don't specify
     * SolutionStackName.
     */
    val platformArn: kotlin.String? = builder.platformArn
    /**
     * The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
     * specified, Elastic Beanstalk sets the configuration values to the default values associated with the
     * specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms in the AWS Elastic Beanstalk
     * Platforms guide.
     * If you specify SolutionStackName, don't specify PlatformArn or
     * TemplateName.
     */
    val solutionStackName: kotlin.String? = builder.solutionStackName
    /**
     * Specifies the tags applied to resources in the environment.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The name of the Elastic Beanstalk configuration template to use with the environment.
     * If you specify TemplateName, then don't specify
     * SolutionStackName.
     */
    val templateName: kotlin.String? = builder.templateName
    /**
     * Specifies the tier to use in creating this environment. The environment tier that you
     * choose determines whether Elastic Beanstalk provisions resources to support a web application that handles
     * HTTP(S) requests or a web application that handles background-processing tasks.
     */
    val tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = builder.tier
    /**
     * The name of the application version to deploy.
     * Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
     */
    val versionLabel: kotlin.String? = builder.versionLabel

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateEnvironmentRequest(")
        append("applicationName=$applicationName,")
        append("cnamePrefix=$cnamePrefix,")
        append("description=$description,")
        append("environmentName=$environmentName,")
        append("groupName=$groupName,")
        append("operationsRole=$operationsRole,")
        append("optionSettings=$optionSettings,")
        append("optionsToRemove=$optionsToRemove,")
        append("platformArn=$platformArn,")
        append("solutionStackName=$solutionStackName,")
        append("tags=$tags,")
        append("templateName=$templateName,")
        append("tier=$tier,")
        append("versionLabel=$versionLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (cnamePrefix?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (operationsRole?.hashCode() ?: 0)
        result = 31 * result + (optionSettings?.hashCode() ?: 0)
        result = 31 * result + (optionsToRemove?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (solutionStackName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (templateName?.hashCode() ?: 0)
        result = 31 * result + (tier?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateEnvironmentRequest

        if (applicationName != other.applicationName) return false
        if (cnamePrefix != other.cnamePrefix) return false
        if (description != other.description) return false
        if (environmentName != other.environmentName) return false
        if (groupName != other.groupName) return false
        if (operationsRole != other.operationsRole) return false
        if (optionSettings != other.optionSettings) return false
        if (optionsToRemove != other.optionsToRemove) return false
        if (platformArn != other.platformArn) return false
        if (solutionStackName != other.solutionStackName) return false
        if (tags != other.tags) return false
        if (templateName != other.templateName) return false
        if (tier != other.tier) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application that is associated with this environment.
         */
        var applicationName: kotlin.String? = null
        /**
         * If specified, the environment attempts to use this value as the prefix for the CNAME in
         * your Elastic Beanstalk environment URL. If not specified, the CNAME is generated automatically by
         * appending a random alphanumeric string to the environment name.
         */
        var cnamePrefix: kotlin.String? = null
        /**
         * Your description for this environment.
         */
        var description: kotlin.String? = null
        /**
         * A unique name for the environment.
         * Constraint: Must be from 4 to 40 characters in length. The name can contain only
         * letters, numbers, and hyphens. It can't start or end with a hyphen. This name must be unique
         * within a region in your account. If the specified name already exists in the region, Elastic Beanstalk returns an
         * InvalidParameterValue error.
         * If you don't specify the CNAMEPrefix parameter, the environment name becomes part of
         * the CNAME, and therefore part of the visible URL for your application.
         */
        var environmentName: kotlin.String? = null
        /**
         * The name of the group to which the target environment belongs. Specify a group name
         * only if the environment's name is specified in an environment manifest and not with the
         * environment name parameter. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
         * (env.yaml) for details.
         */
        var groupName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an existing IAM role to be used as the environment's
         * operations role. If specified, Elastic Beanstalk uses the operations role for permissions to downstream
         * services during this call and during subsequent calls acting on this environment. To specify
         * an operations role, you must have the iam:PassRole permission for the role. For
         * more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
         * AWS Elastic Beanstalk Developer Guide.
         */
        var operationsRole: kotlin.String? = null
        /**
         * If specified, AWS Elastic Beanstalk sets the specified configuration options to the
         * requested value in the configuration set for the new environment. These override the values
         * obtained from the solution stack or the configuration template.
         */
        var optionSettings: List<ConfigurationOptionSetting>? = null
        /**
         * A list of custom user-defined configuration options to remove from the configuration
         * set for this new environment.
         */
        var optionsToRemove: List<OptionSpecification>? = null
        /**
         * The Amazon Resource Name (ARN) of the custom platform to use with the environment. For
         * more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html">Custom Platforms in the
         * AWS Elastic Beanstalk Developer Guide.
         * If you specify PlatformArn, don't specify
         * SolutionStackName.
         */
        var platformArn: kotlin.String? = null
        /**
         * The name of an Elastic Beanstalk solution stack (platform version) to use with the environment. If
         * specified, Elastic Beanstalk sets the configuration values to the default values associated with the
         * specified solution stack. For a list of current solution stacks, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html">Elastic Beanstalk Supported Platforms in the AWS Elastic Beanstalk
         * Platforms guide.
         * If you specify SolutionStackName, don't specify PlatformArn or
         * TemplateName.
         */
        var solutionStackName: kotlin.String? = null
        /**
         * Specifies the tags applied to resources in the environment.
         */
        var tags: List<Tag>? = null
        /**
         * The name of the Elastic Beanstalk configuration template to use with the environment.
         * If you specify TemplateName, then don't specify
         * SolutionStackName.
         */
        var templateName: kotlin.String? = null
        /**
         * Specifies the tier to use in creating this environment. The environment tier that you
         * choose determines whether Elastic Beanstalk provisions resources to support a web application that handles
         * HTTP(S) requests or a web application that handles background-processing tasks.
         */
        var tier: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier? = null
        /**
         * The name of the application version to deploy.
         * Default: If not specified, Elastic Beanstalk attempts to deploy the sample application.
         */
        var versionLabel: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentRequest) : this() {
            this.applicationName = x.applicationName
            this.cnamePrefix = x.cnamePrefix
            this.description = x.description
            this.environmentName = x.environmentName
            this.groupName = x.groupName
            this.operationsRole = x.operationsRole
            this.optionSettings = x.optionSettings
            this.optionsToRemove = x.optionsToRemove
            this.platformArn = x.platformArn
            this.solutionStackName = x.solutionStackName
            this.tags = x.tags
            this.templateName = x.templateName
            this.tier = x.tier
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentRequest = CreateEnvironmentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier] inside the given [block]
         */
        fun tier(block: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.Builder.() -> kotlin.Unit) {
            this.tier = aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier.invoke(block)
        }
    }
}
