// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Request to create or update a group of environments.
 */
class ComposeEnvironmentsRequest private constructor(builder: Builder) {
    /**
     * The name of the application to which the specified source bundles belong.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the group to which the target environments belong. Specify a group name
     * only if the environment name defined in each target environment's manifest ends with a +
     * (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
     * (env.yaml) for details.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * A list of version labels, specifying one or more application source bundles that belong
     * to the target application. Each source bundle must include an environment manifest that
     * specifies the name of the environment and the name of the solution stack to use, and
     * optionally can specify environment links to create.
     */
    val versionLabels: List<String>? = builder.versionLabels

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComposeEnvironmentsRequest(")
        append("applicationName=$applicationName,")
        append("groupName=$groupName,")
        append("versionLabels=$versionLabels)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (versionLabels?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ComposeEnvironmentsRequest

        if (applicationName != other.applicationName) return false
        if (groupName != other.groupName) return false
        if (versionLabels != other.versionLabels) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application to which the specified source bundles belong.
         */
        var applicationName: kotlin.String? = null
        /**
         * The name of the group to which the target environments belong. Specify a group name
         * only if the environment name defined in each target environment's manifest ends with a +
         * (plus) character. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html">Environment Manifest
         * (env.yaml) for details.
         */
        var groupName: kotlin.String? = null
        /**
         * A list of version labels, specifying one or more application source bundles that belong
         * to the target application. Each source bundle must include an environment manifest that
         * specifies the name of the environment and the name of the solution stack to use, and
         * optionally can specify environment links to create.
         */
        var versionLabels: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest) : this() {
            this.applicationName = x.applicationName
            this.groupName = x.groupName
            this.versionLabels = x.versionLabels
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = ComposeEnvironmentsRequest(this)
    }
}
