// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * The application version lifecycle settings for an application. Defines the rules that
 * Elastic Beanstalk applies to an application's versions in order to avoid hitting the
 * per-region limit for application versions.
 * When Elastic Beanstalk deletes an application version from its database, you can no
 * longer deploy that version to an environment. The source bundle remains in S3 unless you
 * configure the rule to delete it.
 */
class ApplicationVersionLifecycleConfig private constructor(builder: Builder) {
    /**
     * Specify a max age rule to restrict the length of time that application versions are
     * retained for an application.
     */
    val maxAgeRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule? = builder.maxAgeRule
    /**
     * Specify a max count rule to restrict the number of application versions that are
     * retained for an application.
     */
    val maxCountRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule? = builder.maxCountRule

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationVersionLifecycleConfig(")
        append("maxAgeRule=$maxAgeRule,")
        append("maxCountRule=$maxCountRule)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxAgeRule?.hashCode() ?: 0
        result = 31 * result + (maxCountRule?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationVersionLifecycleConfig

        if (maxAgeRule != other.maxAgeRule) return false
        if (maxCountRule != other.maxCountRule) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specify a max age rule to restrict the length of time that application versions are
         * retained for an application.
         */
        var maxAgeRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule? = null
        /**
         * Specify a max count rule to restrict the number of application versions that are
         * retained for an application.
         */
        var maxCountRule: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig) : this() {
            this.maxAgeRule = x.maxAgeRule
            this.maxCountRule = x.maxCountRule
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig = ApplicationVersionLifecycleConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule] inside the given [block]
         */
        fun maxAgeRule(block: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule.Builder.() -> kotlin.Unit) {
            this.maxAgeRule = aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule] inside the given [block]
         */
        fun maxCountRule(block: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule.Builder.() -> kotlin.Unit) {
            this.maxCountRule = aws.sdk.kotlin.services.elasticbeanstalk.model.MaxCountRule.invoke(block)
        }
    }
}
