// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of an application version.
 */
class ApplicationVersionDescription private constructor(builder: Builder) {
    /**
     * The name of the application to which the application version belongs.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The Amazon Resource Name (ARN) of the application version.
     */
    val applicationVersionArn: kotlin.String? = builder.applicationVersionArn
    /**
     * Reference to the artifact from the AWS CodeBuild build.
     */
    val buildArn: kotlin.String? = builder.buildArn
    /**
     * The creation date of the application version.
     */
    val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The last modified date of the application version.
     */
    val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * The description of the application version.
     */
    val description: kotlin.String? = builder.description
    /**
     * If the version's source code was retrieved from AWS CodeCommit, the location of the
     * source code for the application version.
     */
    val sourceBuildInformation: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation? = builder.sourceBuildInformation
    /**
     * The storage location of the application version's source bundle in Amazon S3.
     */
    val sourceBundle: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location? = builder.sourceBundle
    /**
     * The processing status of the application version. Reflects the state of the application
     * version during its creation. Many of the values are only applicable if you specified
     * True for the Process parameter of the
     * CreateApplicationVersion action. The following list describes the possible
     * values.
     * Unprocessed – Application version wasn't pre-processed or validated.
     * Elastic Beanstalk will validate configuration files during deployment of the application version to an
     * environment.
     * Processing – Elastic Beanstalk is currently processing the application version.
     * Building – Application version is currently undergoing an AWS CodeBuild build.
     * Processed – Elastic Beanstalk was successfully pre-processed and validated.
     * Failed – Either the AWS CodeBuild build failed or configuration files didn't
     * pass validation. This application version isn't usable.
     */
    val status: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionStatus? = builder.status
    /**
     * A unique identifier for the application version.
     */
    val versionLabel: kotlin.String? = builder.versionLabel

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationVersionDescription(")
        append("applicationName=$applicationName,")
        append("applicationVersionArn=$applicationVersionArn,")
        append("buildArn=$buildArn,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("sourceBuildInformation=$sourceBuildInformation,")
        append("sourceBundle=$sourceBundle,")
        append("status=$status,")
        append("versionLabel=$versionLabel)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (applicationVersionArn?.hashCode() ?: 0)
        result = 31 * result + (buildArn?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (sourceBuildInformation?.hashCode() ?: 0)
        result = 31 * result + (sourceBundle?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (versionLabel?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationVersionDescription

        if (applicationName != other.applicationName) return false
        if (applicationVersionArn != other.applicationVersionArn) return false
        if (buildArn != other.buildArn) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (sourceBuildInformation != other.sourceBuildInformation) return false
        if (sourceBundle != other.sourceBundle) return false
        if (status != other.status) return false
        if (versionLabel != other.versionLabel) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the application to which the application version belongs.
         */
        var applicationName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the application version.
         */
        var applicationVersionArn: kotlin.String? = null
        /**
         * Reference to the artifact from the AWS CodeBuild build.
         */
        var buildArn: kotlin.String? = null
        /**
         * The creation date of the application version.
         */
        var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The last modified date of the application version.
         */
        var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the application version.
         */
        var description: kotlin.String? = null
        /**
         * If the version's source code was retrieved from AWS CodeCommit, the location of the
         * source code for the application version.
         */
        var sourceBuildInformation: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation? = null
        /**
         * The storage location of the application version's source bundle in Amazon S3.
         */
        var sourceBundle: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location? = null
        /**
         * The processing status of the application version. Reflects the state of the application
         * version during its creation. Many of the values are only applicable if you specified
         * True for the Process parameter of the
         * CreateApplicationVersion action. The following list describes the possible
         * values.
         * Unprocessed – Application version wasn't pre-processed or validated.
         * Elastic Beanstalk will validate configuration files during deployment of the application version to an
         * environment.
         * Processing – Elastic Beanstalk is currently processing the application version.
         * Building – Application version is currently undergoing an AWS CodeBuild build.
         * Processed – Elastic Beanstalk was successfully pre-processed and validated.
         * Failed – Either the AWS CodeBuild build failed or configuration files didn't
         * pass validation. This application version isn't usable.
         */
        var status: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionStatus? = null
        /**
         * A unique identifier for the application version.
         */
        var versionLabel: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription) : this() {
            this.applicationName = x.applicationName
            this.applicationVersionArn = x.applicationVersionArn
            this.buildArn = x.buildArn
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.sourceBuildInformation = x.sourceBuildInformation
            this.sourceBundle = x.sourceBundle
            this.status = x.status
            this.versionLabel = x.versionLabel
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription = ApplicationVersionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation] inside the given [block]
         */
        fun sourceBuildInformation(block: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation.Builder.() -> kotlin.Unit) {
            this.sourceBuildInformation = aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location] inside the given [block]
         */
        fun sourceBundle(block: aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location.Builder.() -> kotlin.Unit) {
            this.sourceBundle = aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location.invoke(block)
        }
    }
}
