// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the properties of an application.
 */
class ApplicationDescription private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the application.
     */
    val applicationArn: kotlin.String? = builder.applicationArn
    /**
     * The name of the application.
     */
    val applicationName: kotlin.String? = builder.applicationName
    /**
     * The names of the configuration templates associated with this application.
     */
    val configurationTemplates: List<String>? = builder.configurationTemplates
    /**
     * The date when the application was created.
     */
    val dateCreated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateCreated
    /**
     * The date when the application was last modified.
     */
    val dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.dateUpdated
    /**
     * User-defined description of the application.
     */
    val description: kotlin.String? = builder.description
    /**
     * The lifecycle settings for the application.
     */
    val resourceLifecycleConfig: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig? = builder.resourceLifecycleConfig
    /**
     * The names of the versions for this application.
     */
    val versions: List<String>? = builder.versions

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationDescription(")
        append("applicationArn=$applicationArn,")
        append("applicationName=$applicationName,")
        append("configurationTemplates=$configurationTemplates,")
        append("dateCreated=$dateCreated,")
        append("dateUpdated=$dateUpdated,")
        append("description=$description,")
        append("resourceLifecycleConfig=$resourceLifecycleConfig,")
        append("versions=$versions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationArn?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (configurationTemplates?.hashCode() ?: 0)
        result = 31 * result + (dateCreated?.hashCode() ?: 0)
        result = 31 * result + (dateUpdated?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (resourceLifecycleConfig?.hashCode() ?: 0)
        result = 31 * result + (versions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ApplicationDescription

        if (applicationArn != other.applicationArn) return false
        if (applicationName != other.applicationName) return false
        if (configurationTemplates != other.configurationTemplates) return false
        if (dateCreated != other.dateCreated) return false
        if (dateUpdated != other.dateUpdated) return false
        if (description != other.description) return false
        if (resourceLifecycleConfig != other.resourceLifecycleConfig) return false
        if (versions != other.versions) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the application.
         */
        var applicationArn: kotlin.String? = null
        /**
         * The name of the application.
         */
        var applicationName: kotlin.String? = null
        /**
         * The names of the configuration templates associated with this application.
         */
        var configurationTemplates: List<String>? = null
        /**
         * The date when the application was created.
         */
        var dateCreated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date when the application was last modified.
         */
        var dateUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * User-defined description of the application.
         */
        var description: kotlin.String? = null
        /**
         * The lifecycle settings for the application.
         */
        var resourceLifecycleConfig: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig? = null
        /**
         * The names of the versions for this application.
         */
        var versions: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationDescription) : this() {
            this.applicationArn = x.applicationArn
            this.applicationName = x.applicationName
            this.configurationTemplates = x.configurationTemplates
            this.dateCreated = x.dateCreated
            this.dateUpdated = x.dateUpdated
            this.description = x.description
            this.resourceLifecycleConfig = x.resourceLifecycleConfig
            this.versions = x.versions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationDescription = ApplicationDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig] inside the given [block]
         */
        fun resourceLifecycleConfig(block: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.Builder.() -> kotlin.Unit) {
            this.resourceLifecycleConfig = aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.invoke(block)
        }
    }
}
