// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.elasticbeanstalk.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elasticbeanstalk.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS Elastic Beanstalk</fullname>
 * AWS Elastic Beanstalk makes it easy for you to create, deploy, and manage scalable,
 * fault-tolerant applications running on the Amazon Web Services cloud.
 * For more information about this product, go to the <a href="http://aws.amazon.com/elasticbeanstalk/">AWS Elastic Beanstalk details page. The location of the
 * latest AWS Elastic Beanstalk WSDL is <a href="https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl">https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl.
 * To install the Software Development Kits (SDKs), Integrated Development Environment (IDE)
 * Toolkits, and command line tools that enable you to access the API, go to <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services.
 * Endpoints
 * For a list of region-specific endpoints that AWS Elastic Beanstalk supports, go to
 * <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region">Regions and Endpoints in the Amazon Web Services
 * Glossary.
 */
interface ElasticBeanstalkClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Beanstalk"
    /**
     * ElasticBeanstalkClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): ElasticBeanstalkClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultElasticBeanstalkClient(config)
        }

        operator fun invoke(config: Config): ElasticBeanstalkClient = DefaultElasticBeanstalkClient(config)

        /**
         * Construct a [ElasticBeanstalkClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): ElasticBeanstalkClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return ElasticBeanstalkClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels in-progress environment configuration update or application version
     * deployment.
     */
    suspend fun abortEnvironmentUpdate(input: AbortEnvironmentUpdateRequest): AbortEnvironmentUpdateResponse

    /**
     * Cancels in-progress environment configuration update or application version
     * deployment.
     */
    suspend fun abortEnvironmentUpdate(block: AbortEnvironmentUpdateRequest.Builder.() -> Unit) = abortEnvironmentUpdate(AbortEnvironmentUpdateRequest.Builder().apply(block).build())

    /**
     * Applies a scheduled managed action immediately. A managed action can be applied only if
     * its status is Scheduled. Get the status and action ID of a managed action with
     * DescribeEnvironmentManagedActions.
     */
    suspend fun applyEnvironmentManagedAction(input: ApplyEnvironmentManagedActionRequest): ApplyEnvironmentManagedActionResponse

    /**
     * Applies a scheduled managed action immediately. A managed action can be applied only if
     * its status is Scheduled. Get the status and action ID of a managed action with
     * DescribeEnvironmentManagedActions.
     */
    suspend fun applyEnvironmentManagedAction(block: ApplyEnvironmentManagedActionRequest.Builder.() -> Unit) = applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest.Builder().apply(block).build())

    /**
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk
     * uses the associated operations role for permissions to downstream services during subsequent
     * calls acting on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
     * AWS Elastic Beanstalk Developer Guide.
     */
    suspend fun associateEnvironmentOperationsRole(input: AssociateEnvironmentOperationsRoleRequest): AssociateEnvironmentOperationsRoleResponse

    /**
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk
     * uses the associated operations role for permissions to downstream services during subsequent
     * calls acting on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
     * AWS Elastic Beanstalk Developer Guide.
     */
    suspend fun associateEnvironmentOperationsRole(block: AssociateEnvironmentOperationsRoleRequest.Builder.() -> Unit) = associateEnvironmentOperationsRole(AssociateEnvironmentOperationsRoleRequest.Builder().apply(block).build())

    /**
     * Checks if the specified CNAME is available.
     */
    suspend fun checkDnsAvailability(input: CheckDnsAvailabilityRequest): CheckDnsAvailabilityResponse

    /**
     * Checks if the specified CNAME is available.
     */
    suspend fun checkDnsAvailability(block: CheckDnsAvailabilityRequest.Builder.() -> Unit) = checkDnsAvailability(CheckDnsAvailabilityRequest.Builder().apply(block).build())

    /**
     * Create or update a group of environments that each run a separate component of a single
     * application. Takes a list of version labels that specify application source bundles for each
     * of the environments to create or update. The name of each environment and other required
     * information must be included in the source bundles in an environment manifest named
     * env.yaml. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose Environments
     * for details.
     */
    suspend fun composeEnvironments(input: ComposeEnvironmentsRequest): ComposeEnvironmentsResponse

    /**
     * Create or update a group of environments that each run a separate component of a single
     * application. Takes a list of version labels that specify application source bundles for each
     * of the environments to create or update. The name of each environment and other required
     * information must be included in the source bundles in an environment manifest named
     * env.yaml. See <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html">Compose Environments
     * for details.
     */
    suspend fun composeEnvironments(block: ComposeEnvironmentsRequest.Builder.() -> Unit) = composeEnvironments(ComposeEnvironmentsRequest.Builder().apply(block).build())

    /**
     * Creates an application that has one configuration template named default
     * and no application versions.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application that has one configuration template named default
     * and no application versions.
     */
    suspend fun createApplication(block: CreateApplicationRequest.Builder.() -> Unit) = createApplication(CreateApplicationRequest.Builder().apply(block).build())

    /**
     * Creates an application version for the specified application. You can create an
     * application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the
     * output of an AWS CodeBuild build as follows:
     * Specify a commit in an AWS CodeCommit repository with
     * SourceBuildInformation.
     * Specify a build in an AWS CodeBuild with SourceBuildInformation and
     * BuildConfiguration.
     * Specify a source bundle in S3 with SourceBundle
     * Omit both SourceBuildInformation and SourceBundle to use the
     * default sample application.
     * After you create an application version with a specified Amazon S3 bucket and key
     * location, you can't change that Amazon S3 location. If you change the Amazon S3 location,
     * you receive an exception when you attempt to launch an environment from the application
     * version.
     */
    suspend fun createApplicationVersion(input: CreateApplicationVersionRequest): CreateApplicationVersionResponse

    /**
     * Creates an application version for the specified application. You can create an
     * application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the
     * output of an AWS CodeBuild build as follows:
     * Specify a commit in an AWS CodeCommit repository with
     * SourceBuildInformation.
     * Specify a build in an AWS CodeBuild with SourceBuildInformation and
     * BuildConfiguration.
     * Specify a source bundle in S3 with SourceBundle
     * Omit both SourceBuildInformation and SourceBundle to use the
     * default sample application.
     * After you create an application version with a specified Amazon S3 bucket and key
     * location, you can't change that Amazon S3 location. If you change the Amazon S3 location,
     * you receive an exception when you attempt to launch an environment from the application
     * version.
     */
    suspend fun createApplicationVersion(block: CreateApplicationVersionRequest.Builder.() -> Unit) = createApplicationVersion(CreateApplicationVersionRequest.Builder().apply(block).build())

    /**
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You
     * can then use the configuration template to deploy different versions of the application with
     * the same configuration settings.
     * Templates aren't associated with any environment. The EnvironmentName
     * response element is always null.
     * Related Topics
     * DescribeConfigurationOptions
     * DescribeConfigurationSettings
     * ListAvailableSolutionStacks
     */
    suspend fun createConfigurationTemplate(input: CreateConfigurationTemplateRequest): CreateConfigurationTemplateResponse

    /**
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk
     * application. You define application configuration settings in a configuration template. You
     * can then use the configuration template to deploy different versions of the application with
     * the same configuration settings.
     * Templates aren't associated with any environment. The EnvironmentName
     * response element is always null.
     * Related Topics
     * DescribeConfigurationOptions
     * DescribeConfigurationSettings
     * ListAvailableSolutionStacks
     */
    suspend fun createConfigurationTemplate(block: CreateConfigurationTemplateRequest.Builder.() -> Unit) = createConfigurationTemplate(CreateConfigurationTemplateRequest.Builder().apply(block).build())

    /**
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified
     * configuration.
     */
    suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified
     * configuration.
     */
    suspend fun createEnvironment(block: CreateEnvironmentRequest.Builder.() -> Unit) = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

    /**
     * Create a new version of your custom platform.
     */
    suspend fun createPlatformVersion(input: CreatePlatformVersionRequest): CreatePlatformVersionResponse

    /**
     * Create a new version of your custom platform.
     */
    suspend fun createPlatformVersion(block: CreatePlatformVersionRequest.Builder.() -> Unit) = createPlatformVersion(CreatePlatformVersionRequest.Builder().apply(block).build())

    /**
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used
     * by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the
     * first time you create an environment in a region. If the storage location already exists,
     * CreateStorageLocation still returns the bucket name but does not create a new
     * bucket.
     */
    suspend fun createStorageLocation(input: CreateStorageLocationRequest): CreateStorageLocationResponse

    /**
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used
     * by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the
     * first time you create an environment in a region. If the storage location already exists,
     * CreateStorageLocation still returns the bucket name but does not create a new
     * bucket.
     */
    suspend fun createStorageLocation(block: CreateStorageLocationRequest.Builder.() -> Unit) = createStorageLocation(CreateStorageLocationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified application along with all associated versions and
     * configurations. The application versions will not be deleted from your Amazon S3
     * bucket.
     * You cannot delete an application that has a running environment.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes the specified application along with all associated versions and
     * configurations. The application versions will not be deleted from your Amazon S3
     * bucket.
     * You cannot delete an application that has a running environment.
     */
    suspend fun deleteApplication(block: DeleteApplicationRequest.Builder.() -> Unit) = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified version from the specified application.
     * You cannot delete an application version that is associated with a running
     * environment.
     */
    suspend fun deleteApplicationVersion(input: DeleteApplicationVersionRequest): DeleteApplicationVersionResponse

    /**
     * Deletes the specified version from the specified application.
     * You cannot delete an application version that is associated with a running
     * environment.
     */
    suspend fun deleteApplicationVersion(block: DeleteApplicationVersionRequest.Builder.() -> Unit) = deleteApplicationVersion(DeleteApplicationVersionRequest.Builder().apply(block).build())

    /**
     * Deletes the specified configuration template.
     * When you launch an environment using a configuration template, the environment gets a
     * copy of the template. You can delete or modify the environment's copy of the template
     * without affecting the running environment.
     */
    suspend fun deleteConfigurationTemplate(input: DeleteConfigurationTemplateRequest): DeleteConfigurationTemplateResponse

    /**
     * Deletes the specified configuration template.
     * When you launch an environment using a configuration template, the environment gets a
     * copy of the template. You can delete or modify the environment's copy of the template
     * without affecting the running environment.
     */
    suspend fun deleteConfigurationTemplate(block: DeleteConfigurationTemplateRequest.Builder.() -> Unit) = deleteConfigurationTemplate(DeleteConfigurationTemplateRequest.Builder().apply(block).build())

    /**
     * Deletes the draft configuration associated with the running environment.
     * Updating a running environment with any configuration changes creates a draft
     * configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update
     * fails. The DeploymentStatus for the draft configuration indicates whether the
     * deployment is in process or has failed. The draft configuration remains in existence until it
     * is deleted with this action.
     */
    suspend fun deleteEnvironmentConfiguration(input: DeleteEnvironmentConfigurationRequest): DeleteEnvironmentConfigurationResponse

    /**
     * Deletes the draft configuration associated with the running environment.
     * Updating a running environment with any configuration changes creates a draft
     * configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update
     * fails. The DeploymentStatus for the draft configuration indicates whether the
     * deployment is in process or has failed. The draft configuration remains in existence until it
     * is deleted with this action.
     */
    suspend fun deleteEnvironmentConfiguration(block: DeleteEnvironmentConfigurationRequest.Builder.() -> Unit) = deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest.Builder().apply(block).build())

    /**
     * Deletes the specified version of a custom platform.
     */
    suspend fun deletePlatformVersion(input: DeletePlatformVersionRequest): DeletePlatformVersionResponse

    /**
     * Deletes the specified version of a custom platform.
     */
    suspend fun deletePlatformVersion(block: DeletePlatformVersionRequest.Builder.() -> Unit) = deletePlatformVersion(DeletePlatformVersionRequest.Builder().apply(block).build())

    /**
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS
     * account.
     * The result currently has one set of attributes—resource quotas.
     */
    suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest): DescribeAccountAttributesResponse

    /**
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS
     * account.
     * The result currently has one set of attributes—resource quotas.
     */
    suspend fun describeAccountAttributes(block: DescribeAccountAttributesRequest.Builder.() -> Unit) = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

    /**
     * Retrieve a list of application versions.
     */
    suspend fun describeApplicationVersions(input: DescribeApplicationVersionsRequest): DescribeApplicationVersionsResponse

    /**
     * Retrieve a list of application versions.
     */
    suspend fun describeApplicationVersions(block: DescribeApplicationVersionsRequest.Builder.() -> Unit) = describeApplicationVersions(DescribeApplicationVersionsRequest.Builder().apply(block).build())

    /**
     * Returns the descriptions of existing applications.
     */
    suspend fun describeApplications(input: DescribeApplicationsRequest): DescribeApplicationsResponse

    /**
     * Returns the descriptions of existing applications.
     */
    suspend fun describeApplications(block: DescribeApplicationsRequest.Builder.() -> Unit) = describeApplications(DescribeApplicationsRequest.Builder().apply(block).build())

    /**
     * Describes the configuration options that are used in a particular configuration
     * template or environment, or that a specified solution stack defines. The description includes
     * the values the options, their default values, and an indication of the required action on a
     * running environment if an option value is changed.
     */
    suspend fun describeConfigurationOptions(input: DescribeConfigurationOptionsRequest): DescribeConfigurationOptionsResponse

    /**
     * Describes the configuration options that are used in a particular configuration
     * template or environment, or that a specified solution stack defines. The description includes
     * the values the options, their default values, and an indication of the required action on a
     * running environment if an option value is changed.
     */
    suspend fun describeConfigurationOptions(block: DescribeConfigurationOptionsRequest.Builder.() -> Unit) = describeConfigurationOptions(DescribeConfigurationOptionsRequest.Builder().apply(block).build())

    /**
     * Returns a description of the settings for the specified configuration set, that is,
     * either a configuration template or the configuration set associated with a running
     * environment.
     * When describing the settings for the configuration set associated with a running
     * environment, it is possible to receive two sets of setting descriptions. One is the deployed
     * configuration set, and the other is a draft configuration of an environment that is either in
     * the process of deployment or that failed to deploy.
     * Related Topics
     * DeleteEnvironmentConfiguration
     */
    suspend fun describeConfigurationSettings(input: DescribeConfigurationSettingsRequest): DescribeConfigurationSettingsResponse

    /**
     * Returns a description of the settings for the specified configuration set, that is,
     * either a configuration template or the configuration set associated with a running
     * environment.
     * When describing the settings for the configuration set associated with a running
     * environment, it is possible to receive two sets of setting descriptions. One is the deployed
     * configuration set, and the other is a draft configuration of an environment that is either in
     * the process of deployment or that failed to deploy.
     * Related Topics
     * DeleteEnvironmentConfiguration
     */
    suspend fun describeConfigurationSettings(block: DescribeConfigurationSettingsRequest.Builder.() -> Unit) = describeConfigurationSettings(DescribeConfigurationSettingsRequest.Builder().apply(block).build())

    /**
     * Returns information about the overall health of the specified environment. The
     * DescribeEnvironmentHealth operation is only available with
     * AWS Elastic Beanstalk Enhanced Health.
     */
    suspend fun describeEnvironmentHealth(input: DescribeEnvironmentHealthRequest): DescribeEnvironmentHealthResponse

    /**
     * Returns information about the overall health of the specified environment. The
     * DescribeEnvironmentHealth operation is only available with
     * AWS Elastic Beanstalk Enhanced Health.
     */
    suspend fun describeEnvironmentHealth(block: DescribeEnvironmentHealthRequest.Builder.() -> Unit) = describeEnvironmentHealth(DescribeEnvironmentHealthRequest.Builder().apply(block).build())

    /**
     * Lists an environment's completed and failed managed actions.
     */
    suspend fun describeEnvironmentManagedActionHistory(input: DescribeEnvironmentManagedActionHistoryRequest): DescribeEnvironmentManagedActionHistoryResponse

    /**
     * Lists an environment's completed and failed managed actions.
     */
    suspend fun describeEnvironmentManagedActionHistory(block: DescribeEnvironmentManagedActionHistoryRequest.Builder.() -> Unit) = describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest.Builder().apply(block).build())

    /**
     * Lists an environment's upcoming and in-progress managed actions.
     */
    suspend fun describeEnvironmentManagedActions(input: DescribeEnvironmentManagedActionsRequest): DescribeEnvironmentManagedActionsResponse

    /**
     * Lists an environment's upcoming and in-progress managed actions.
     */
    suspend fun describeEnvironmentManagedActions(block: DescribeEnvironmentManagedActionsRequest.Builder.() -> Unit) = describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest.Builder().apply(block).build())

    /**
     * Returns AWS resources for this environment.
     */
    suspend fun describeEnvironmentResources(input: DescribeEnvironmentResourcesRequest): DescribeEnvironmentResourcesResponse

    /**
     * Returns AWS resources for this environment.
     */
    suspend fun describeEnvironmentResources(block: DescribeEnvironmentResourcesRequest.Builder.() -> Unit) = describeEnvironmentResources(DescribeEnvironmentResourcesRequest.Builder().apply(block).build())

    /**
     * Returns descriptions for existing environments.
     */
    suspend fun describeEnvironments(input: DescribeEnvironmentsRequest): DescribeEnvironmentsResponse

    /**
     * Returns descriptions for existing environments.
     */
    suspend fun describeEnvironments(block: DescribeEnvironmentsRequest.Builder.() -> Unit) = describeEnvironments(DescribeEnvironmentsRequest.Builder().apply(block).build())

    /**
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * This action returns the most recent 1,000 events from the specified
     * NextToken.
     */
    suspend fun describeEvents(input: DescribeEventsRequest): DescribeEventsResponse

    /**
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     * This action returns the most recent 1,000 events from the specified
     * NextToken.
     */
    suspend fun describeEvents(block: DescribeEventsRequest.Builder.() -> Unit) = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

    /**
     * Retrieves detailed information about the health of instances in your AWS Elastic
     * Beanstalk. This operation requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting.
     */
    suspend fun describeInstancesHealth(input: DescribeInstancesHealthRequest): DescribeInstancesHealthResponse

    /**
     * Retrieves detailed information about the health of instances in your AWS Elastic
     * Beanstalk. This operation requires <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html">enhanced health
     * reporting.
     */
    suspend fun describeInstancesHealth(block: DescribeInstancesHealthRequest.Builder.() -> Unit) = describeInstancesHealth(DescribeInstancesHealthRequest.Builder().apply(block).build())

    /**
     * Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of
     * platform versions.
     * For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun describePlatformVersion(input: DescribePlatformVersionRequest): DescribePlatformVersionResponse

    /**
     * Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of
     * platform versions.
     * For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun describePlatformVersion(block: DescribePlatformVersionRequest.Builder.() -> Unit) = describePlatformVersion(DescribePlatformVersionRequest.Builder().apply(block).build())

    /**
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses
     * the caller's permissions for permissions to downstream services during subsequent calls acting
     * on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
     * AWS Elastic Beanstalk Developer Guide.
     */
    suspend fun disassociateEnvironmentOperationsRole(input: DisassociateEnvironmentOperationsRoleRequest): DisassociateEnvironmentOperationsRoleResponse

    /**
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses
     * the caller's permissions for permissions to downstream services during subsequent calls acting
     * on this environment. For more information, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html">Operations roles in the
     * AWS Elastic Beanstalk Developer Guide.
     */
    suspend fun disassociateEnvironmentOperationsRole(block: DisassociateEnvironmentOperationsRoleRequest.Builder.() -> Unit) = disassociateEnvironmentOperationsRole(DisassociateEnvironmentOperationsRoleRequest.Builder().apply(block).build())

    /**
     * Returns a list of the available solution stack names, with the public version first and
     * then in reverse chronological order.
     */
    suspend fun listAvailableSolutionStacks(input: ListAvailableSolutionStacksRequest): ListAvailableSolutionStacksResponse

    /**
     * Returns a list of the available solution stack names, with the public version first and
     * then in reverse chronological order.
     */
    suspend fun listAvailableSolutionStacks(block: ListAvailableSolutionStacksRequest.Builder.() -> Unit) = listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.Builder().apply(block).build())

    /**
     * Lists the platform branches available for your account in an AWS Region. Provides
     * summary information about each platform branch.
     * For definitions of platform branch and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun listPlatformBranches(input: ListPlatformBranchesRequest): ListPlatformBranchesResponse

    /**
     * Lists the platform branches available for your account in an AWS Region. Provides
     * summary information about each platform branch.
     * For definitions of platform branch and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun listPlatformBranches(block: ListPlatformBranchesRequest.Builder.() -> Unit) = listPlatformBranches(ListPlatformBranchesRequest.Builder().apply(block).build())

    /**
     * Lists the platform versions available for your account in an AWS Region. Provides
     * summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform
     * version.
     * For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun listPlatformVersions(input: ListPlatformVersionsRequest): ListPlatformVersionsResponse

    /**
     * Lists the platform versions available for your account in an AWS Region. Provides
     * summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform
     * version.
     * For definitions of platform version and other platform-related terms, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html">AWS Elastic Beanstalk
     * Platforms Glossary.
     */
    suspend fun listPlatformVersions(block: ListPlatformVersionsRequest.Builder.() -> Unit) = listPlatformVersions(ListPlatformVersionsRequest.Builder().apply(block).build())

    /**
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
     * <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
     * Resources.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
     * <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
     * Resources.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group,
     * load balancer, etc.) for a specified environment and forces a restart.
     */
    suspend fun rebuildEnvironment(input: RebuildEnvironmentRequest): RebuildEnvironmentResponse

    /**
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group,
     * load balancer, etc.) for a specified environment and forces a restart.
     */
    suspend fun rebuildEnvironment(block: RebuildEnvironmentRequest.Builder.() -> Unit) = rebuildEnvironment(RebuildEnvironmentRequest.Builder().apply(block).build())

    /**
     * Initiates a request to compile the specified type of information of the deployed
     * environment.
     * Setting the InfoType to tail compiles the last lines from
     * the application server log files of every Amazon EC2 instance in your environment.
     * Setting the InfoType to bundle compresses the application
     * server log files for every Amazon EC2 instance into a .zip file. Legacy and .NET
     * containers do not support bundle logs.
     * Use RetrieveEnvironmentInfo to obtain the set of logs.
     * Related Topics
     * RetrieveEnvironmentInfo
     */
    suspend fun requestEnvironmentInfo(input: RequestEnvironmentInfoRequest): RequestEnvironmentInfoResponse

    /**
     * Initiates a request to compile the specified type of information of the deployed
     * environment.
     * Setting the InfoType to tail compiles the last lines from
     * the application server log files of every Amazon EC2 instance in your environment.
     * Setting the InfoType to bundle compresses the application
     * server log files for every Amazon EC2 instance into a .zip file. Legacy and .NET
     * containers do not support bundle logs.
     * Use RetrieveEnvironmentInfo to obtain the set of logs.
     * Related Topics
     * RetrieveEnvironmentInfo
     */
    suspend fun requestEnvironmentInfo(block: RequestEnvironmentInfoRequest.Builder.() -> Unit) = requestEnvironmentInfo(RequestEnvironmentInfoRequest.Builder().apply(block).build())

    /**
     * Causes the environment to restart the application container server running on each
     * Amazon EC2 instance.
     */
    suspend fun restartAppServer(input: RestartAppServerRequest): RestartAppServerResponse

    /**
     * Causes the environment to restart the application container server running on each
     * Amazon EC2 instance.
     */
    suspend fun restartAppServer(block: RestartAppServerRequest.Builder.() -> Unit) = restartAppServer(RestartAppServerRequest.Builder().apply(block).build())

    /**
     * Retrieves the compiled information from a RequestEnvironmentInfo
     * request.
     * Related Topics
     * RequestEnvironmentInfo
     */
    suspend fun retrieveEnvironmentInfo(input: RetrieveEnvironmentInfoRequest): RetrieveEnvironmentInfoResponse

    /**
     * Retrieves the compiled information from a RequestEnvironmentInfo
     * request.
     * Related Topics
     * RequestEnvironmentInfo
     */
    suspend fun retrieveEnvironmentInfo(block: RetrieveEnvironmentInfoRequest.Builder.() -> Unit) = retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest.Builder().apply(block).build())

    /**
     * Swaps the CNAMEs of two environments.
     */
    suspend fun swapEnvironmentCnamEs(input: SwapEnvironmentCnamEsRequest): SwapEnvironmentCnamEsResponse

    /**
     * Swaps the CNAMEs of two environments.
     */
    suspend fun swapEnvironmentCnamEs(block: SwapEnvironmentCnamEsRequest.Builder.() -> Unit) = swapEnvironmentCnamEs(SwapEnvironmentCnamEsRequest.Builder().apply(block).build())

    /**
     * Terminates the specified environment.
     */
    suspend fun terminateEnvironment(input: TerminateEnvironmentRequest): TerminateEnvironmentResponse

    /**
     * Terminates the specified environment.
     */
    suspend fun terminateEnvironment(block: TerminateEnvironmentRequest.Builder.() -> Unit) = terminateEnvironment(TerminateEnvironmentRequest.Builder().apply(block).build())

    /**
     * Updates the specified application to have the specified properties.
     * If a property (for example, description) is not provided, the value
     * remains unchanged. To clear these properties, specify an empty string.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Updates the specified application to have the specified properties.
     * If a property (for example, description) is not provided, the value
     * remains unchanged. To clear these properties, specify an empty string.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.Builder.() -> Unit) = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

    /**
     * Modifies lifecycle settings for an application.
     */
    suspend fun updateApplicationResourceLifecycle(input: UpdateApplicationResourceLifecycleRequest): UpdateApplicationResourceLifecycleResponse

    /**
     * Modifies lifecycle settings for an application.
     */
    suspend fun updateApplicationResourceLifecycle(block: UpdateApplicationResourceLifecycleRequest.Builder.() -> Unit) = updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest.Builder().apply(block).build())

    /**
     * Updates the specified application version to have the specified properties.
     * If a property (for example, description) is not provided, the value
     * remains unchanged. To clear properties, specify an empty string.
     */
    suspend fun updateApplicationVersion(input: UpdateApplicationVersionRequest): UpdateApplicationVersionResponse

    /**
     * Updates the specified application version to have the specified properties.
     * If a property (for example, description) is not provided, the value
     * remains unchanged. To clear properties, specify an empty string.
     */
    suspend fun updateApplicationVersion(block: UpdateApplicationVersionRequest.Builder.() -> Unit) = updateApplicationVersion(UpdateApplicationVersionRequest.Builder().apply(block).build())

    /**
     * Updates the specified configuration template to have the specified properties or
     * configuration option values.
     * If a property (for example, ApplicationName) is not provided, its value
     * remains unchanged. To clear such properties, specify an empty string.
     * Related Topics
     * DescribeConfigurationOptions
     */
    suspend fun updateConfigurationTemplate(input: UpdateConfigurationTemplateRequest): UpdateConfigurationTemplateResponse

    /**
     * Updates the specified configuration template to have the specified properties or
     * configuration option values.
     * If a property (for example, ApplicationName) is not provided, its value
     * remains unchanged. To clear such properties, specify an empty string.
     * Related Topics
     * DescribeConfigurationOptions
     */
    suspend fun updateConfigurationTemplate(block: UpdateConfigurationTemplateRequest.Builder.() -> Unit) = updateConfigurationTemplate(UpdateConfigurationTemplateRequest.Builder().apply(block).build())

    /**
     * Updates the environment description, deploys a new application version, updates the
     * configuration settings to an entirely new configuration template, or updates select
     * configuration option values in the running environment.
     * Attempting to update both the release and configuration is not allowed and AWS Elastic
     * Beanstalk returns an InvalidParameterCombination error.
     * When updating the configuration settings to a new template or individual settings, a
     * draft configuration is created and DescribeConfigurationSettings for this
     * environment returns two setting descriptions with different DeploymentStatus
     * values.
     */
    suspend fun updateEnvironment(input: UpdateEnvironmentRequest): UpdateEnvironmentResponse

    /**
     * Updates the environment description, deploys a new application version, updates the
     * configuration settings to an entirely new configuration template, or updates select
     * configuration option values in the running environment.
     * Attempting to update both the release and configuration is not allowed and AWS Elastic
     * Beanstalk returns an InvalidParameterCombination error.
     * When updating the configuration settings to a new template or individual settings, a
     * draft configuration is created and DescribeConfigurationSettings for this
     * environment returns two setting descriptions with different DeploymentStatus
     * values.
     */
    suspend fun updateEnvironment(block: UpdateEnvironmentRequest.Builder.() -> Unit) = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

    /**
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: TagsToAdd
     * for tags to add or update, and TagsToRemove.
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
     * <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
     * Resources.
     * If you create a custom IAM user policy to control permission to this operation, specify
     * one of the following two virtual actions (or both) instead of the API operation name:
     * elasticbeanstalk:AddTags
     * Controls permission to call UpdateTagsForResource and pass a list of tags to add in the TagsToAdd
     * parameter.
     * elasticbeanstalk:RemoveTags
     * Controls permission to call UpdateTagsForResource and pass a list of tag keys to remove in the TagsToRemove
     * parameter.
     * For details about creating a custom user policy, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies">Creating a Custom User Policy.
     */
    suspend fun updateTagsForResource(input: UpdateTagsForResourceRequest): UpdateTagsForResourceResponse

    /**
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: TagsToAdd
     * for tags to add or update, and TagsToRemove.
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see
     * <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html">Tagging Application
     * Resources.
     * If you create a custom IAM user policy to control permission to this operation, specify
     * one of the following two virtual actions (or both) instead of the API operation name:
     * elasticbeanstalk:AddTags
     * Controls permission to call UpdateTagsForResource and pass a list of tags to add in the TagsToAdd
     * parameter.
     * elasticbeanstalk:RemoveTags
     * Controls permission to call UpdateTagsForResource and pass a list of tag keys to remove in the TagsToRemove
     * parameter.
     * For details about creating a custom user policy, see <a href="https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies">Creating a Custom User Policy.
     */
    suspend fun updateTagsForResource(block: UpdateTagsForResourceRequest.Builder.() -> Unit) = updateTagsForResource(UpdateTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Takes a set of configuration settings and either a configuration template or
     * environment, and determines whether those values are valid.
     * This action returns a list of messages indicating any errors or warnings associated
     * with the selection of option values.
     */
    suspend fun validateConfigurationSettings(input: ValidateConfigurationSettingsRequest): ValidateConfigurationSettingsResponse

    /**
     * Takes a set of configuration settings and either a configuration template or
     * environment, and determines whether those values are valid.
     * This action returns a list of messages indicating any errors or warnings associated
     * with the selection of option values.
     */
    suspend fun validateConfigurationSettings(block: ValidateConfigurationSettingsRequest.Builder.() -> Unit) = validateConfigurationSettings(ValidateConfigurationSettingsRequest.Builder().apply(block).build())
}
