// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationSettingsDescription
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeConfigurationSettingsDescriptionDocument(reader: XmlTagReader): ConfigurationSettingsDescription {
    val builder = ConfigurationSettingsDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // SolutionStackName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$SolutionStackName
            "SolutionStackName" -> builder.solutionStackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#SolutionStackName`)" }
            // PlatformArn com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // TemplateName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$TemplateName
            "TemplateName" -> builder.templateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationTemplateName`)" }
            // Description com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // EnvironmentName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // DeploymentStatus com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DeploymentStatus
            "DeploymentStatus" -> builder.deploymentStatus = curr.tryData()
                .parse { ConfigurationDeploymentStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ConfigurationDeploymentStatus`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // OptionSettings com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$OptionSettings
            "OptionSettings" -> builder.optionSettings = deserializeConfigurationOptionSettingsListShape(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
