// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Location of the source code for an application version.
 */
public class SourceBuildInformation private constructor(builder: Builder) {
    /**
     * The location of the source code, as a formatted string, depending on the value of `SourceRepository`
     * + For `CodeCommit`, the format is the repository name and commit ID, separated by a forward slash. For example, `my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a`.
     * + For `S3`, the format is the S3 bucket name and object key, separated by a forward slash. For example, `my-s3-bucket/Folders/my-source-file`.
     */
    public val sourceLocation: kotlin.String = requireNotNull(builder.sourceLocation) { "A non-null value must be provided for sourceLocation" }
    /**
     * Location where the repository is stored.
     * + `CodeCommit`
     * + `S3`
     */
    public val sourceRepository: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceRepository = requireNotNull(builder.sourceRepository) { "A non-null value must be provided for sourceRepository" }
    /**
     * The type of repository.
     * + `Git`
     * + `Zip`
     */
    public val sourceType: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceType = requireNotNull(builder.sourceType) { "A non-null value must be provided for sourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceBuildInformation(")
        append("sourceLocation=$sourceLocation,")
        append("sourceRepository=$sourceRepository,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = sourceLocation.hashCode()
        result = 31 * result + (sourceRepository.hashCode())
        result = 31 * result + (sourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceBuildInformation

        if (sourceLocation != other.sourceLocation) return false
        if (sourceRepository != other.sourceRepository) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location of the source code, as a formatted string, depending on the value of `SourceRepository`
         * + For `CodeCommit`, the format is the repository name and commit ID, separated by a forward slash. For example, `my-git-repo/265cfa0cf6af46153527f55d6503ec030551f57a`.
         * + For `S3`, the format is the S3 bucket name and object key, separated by a forward slash. For example, `my-s3-bucket/Folders/my-source-file`.
         */
        public var sourceLocation: kotlin.String? = null
        /**
         * Location where the repository is stored.
         * + `CodeCommit`
         * + `S3`
         */
        public var sourceRepository: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceRepository? = null
        /**
         * The type of repository.
         * + `Git`
         * + `Zip`
         */
        public var sourceType: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation) : this() {
            this.sourceLocation = x.sourceLocation
            this.sourceRepository = x.sourceRepository
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation = SourceBuildInformation(this)

        internal fun correctErrors(): Builder {
            if (sourceLocation == null) sourceLocation = ""
            if (sourceRepository == null) sourceRepository = SourceRepository.SdkUnknown("no value provided")
            if (sourceType == null) sourceType = SourceType.SdkUnknown("no value provided")
            return this
        }
    }
}
