// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes criteria to restrict a list of results.
 *
 * For operators that apply a single value to the attribute, the filter is evaluated as follows: `Attribute Operator Values[1]`
 *
 * Some operators, e.g. `in`, can apply multiple values. In this case, the filter is evaluated as a logical union (OR) of applications of the operator to the attribute with each one of the values: `(Attribute Operator Values[1]) OR (Attribute Operator Values[2]) OR ...`
 *
 * The valid values for attributes of `SearchFilter` depend on the API action. For valid values, see the reference page for the API action you're calling that takes a `SearchFilter` parameter.
 */
public class SearchFilter private constructor(builder: Builder) {
    /**
     * The result attribute to which the filter values are applied. Valid values vary by API action.
     */
    public val attribute: kotlin.String? = builder.attribute
    /**
     * The operator to apply to the `Attribute` with each of the `Values`. Valid values vary by `Attribute`.
     */
    public val operator: kotlin.String? = builder.operator
    /**
     * The list of values applied to the `Attribute` and `Operator` attributes. Number of values and valid values vary by `Attribute`.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchFilter(")
        append("attribute=$attribute,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchFilter

        if (attribute != other.attribute) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The result attribute to which the filter values are applied. Valid values vary by API action.
         */
        public var attribute: kotlin.String? = null
        /**
         * The operator to apply to the `Attribute` with each of the `Values`. Valid values vary by `Attribute`.
         */
        public var operator: kotlin.String? = null
        /**
         * The list of values applied to the `Attribute` and `Operator` attributes. Number of values and valid values vary by `Attribute`.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter) : this() {
            this.attribute = x.attribute
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.SearchFilter = SearchFilter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
