// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The resource lifecycle configuration for an application. Defines lifecycle settings for resources that belong to the application, and the service role that AWS Elastic Beanstalk assumes in order to apply lifecycle settings. The version lifecycle configuration defines lifecycle settings for application versions.
 */
public class ApplicationResourceLifecycleConfig private constructor(builder: Builder) {
    /**
     * The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
     *
     * The `ServiceRole` property is required the first time that you provide a `VersionLifecycleConfig` for the application in one of the supporting calls (`CreateApplication` or `UpdateApplicationResourceLifecycle`). After you provide it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the application, and you don't need to specify it again in subsequent `UpdateApplicationResourceLifecycle` calls. You can, however, specify it in subsequent calls to change the Service Role to another value.
     */
    public val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * Defines lifecycle settings for application versions.
     */
    public val versionLifecycleConfig: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig? = builder.versionLifecycleConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationResourceLifecycleConfig(")
        append("serviceRole=$serviceRole,")
        append("versionLifecycleConfig=$versionLifecycleConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = serviceRole?.hashCode() ?: 0
        result = 31 * result + (versionLifecycleConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationResourceLifecycleConfig

        if (serviceRole != other.serviceRole) return false
        if (versionLifecycleConfig != other.versionLifecycleConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of an IAM service role that Elastic Beanstalk has permission to assume.
         *
         * The `ServiceRole` property is required the first time that you provide a `VersionLifecycleConfig` for the application in one of the supporting calls (`CreateApplication` or `UpdateApplicationResourceLifecycle`). After you provide it once, in either one of the calls, Elastic Beanstalk persists the Service Role with the application, and you don't need to specify it again in subsequent `UpdateApplicationResourceLifecycle` calls. You can, however, specify it in subsequent calls to change the Service Role to another value.
         */
        public var serviceRole: kotlin.String? = null
        /**
         * Defines lifecycle settings for application versions.
         */
        public var versionLifecycleConfig: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig) : this() {
            this.serviceRole = x.serviceRole
            this.versionLifecycleConfig = x.versionLifecycleConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig = ApplicationResourceLifecycleConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig] inside the given [block]
         */
        public fun versionLifecycleConfig(block: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.Builder.() -> kotlin.Unit) {
            this.versionLifecycleConfig = aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionLifecycleConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
