// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Request to create or update a group of environments.
 */
public class ComposeEnvironmentsRequest private constructor(builder: Builder) {
    /**
     * The name of the application to which the specified source bundles belong.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See [Environment Manifest (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html) for details.
     */
    public val groupName: kotlin.String? = builder.groupName
    /**
     * A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.
     */
    public val versionLabels: List<String>? = builder.versionLabels

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComposeEnvironmentsRequest(")
        append("applicationName=$applicationName,")
        append("groupName=$groupName,")
        append("versionLabels=$versionLabels")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (versionLabels?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComposeEnvironmentsRequest

        if (applicationName != other.applicationName) return false
        if (groupName != other.groupName) return false
        if (versionLabels != other.versionLabels) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the application to which the specified source bundles belong.
         */
        public var applicationName: kotlin.String? = null
        /**
         * The name of the group to which the target environments belong. Specify a group name only if the environment name defined in each target environment's manifest ends with a + (plus) character. See [Environment Manifest (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html) for details.
         */
        public var groupName: kotlin.String? = null
        /**
         * A list of version labels, specifying one or more application source bundles that belong to the target application. Each source bundle must include an environment manifest that specifies the name of the environment and the name of the solution stack to use, and optionally can specify environment links to create.
         */
        public var versionLabels: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest) : this() {
            this.applicationName = x.applicationName
            this.groupName = x.groupName
            this.versionLabels = x.versionLabels
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest = ComposeEnvironmentsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
