// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth
import aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeEnvironmentHealthOperationDeserializer: HttpDeserializer.NonStreaming<DescribeEnvironmentHealthResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeEnvironmentHealthResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEnvironmentHealthError(context, call, payload)
        }
        val builder = DescribeEnvironmentHealthResponse.Builder()

        if (payload != null) {
            deserializeDescribeEnvironmentHealthOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeEnvironmentHealthError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ElasticBeanstalkServiceException" -> ElasticBeanstalkServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEnvironmentHealthOperationBody(builder: DescribeEnvironmentHealthResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "DescribeEnvironmentHealth")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationMetrics com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$ApplicationMetrics
            "ApplicationMetrics" -> builder.applicationMetrics = deserializeApplicationMetricsDocument(curr)
            // Causes com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$Causes
            "Causes" -> builder.causes = deserializeCausesShape(curr)
            // Color com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$Color
            "Color" -> builder.color = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // EnvironmentName com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // HealthStatus com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$HealthStatus
            "HealthStatus" -> builder.healthStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // InstancesHealth com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$InstancesHealth
            "InstancesHealth" -> builder.instancesHealth = deserializeInstanceHealthSummaryDocument(curr)
            // RefreshedAt com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$RefreshedAt
            "RefreshedAt" -> builder.refreshedAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#RefreshedAt`)" }
            // Status com.amazonaws.elasticbeanstalk#DescribeEnvironmentHealthResult$Status
            "Status" -> builder.status = curr.tryData()
                .parse { EnvironmentHealth.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentHealth`)" }
            else -> {}
        }
        curr.drop()
    }
}
