// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Summary information about a platform version.
 */
public class PlatformSummary private constructor(builder: Builder) {
    /**
     * The operating system used by the platform version.
     */
    public val operatingSystemName: kotlin.String? = builder.operatingSystemName
    /**
     * The version of the operating system used by the platform version.
     */
    public val operatingSystemVersion: kotlin.String? = builder.operatingSystemVersion
    /**
     * The ARN of the platform version.
     */
    public val platformArn: kotlin.String? = builder.platformArn
    /**
     * The state of the platform version's branch in its lifecycle.
     *
     * Possible values: `beta` | `supported` | `deprecated` | `retired`
     */
    public val platformBranchLifecycleState: kotlin.String? = builder.platformBranchLifecycleState
    /**
     * The platform branch to which the platform version belongs.
     */
    public val platformBranchName: kotlin.String? = builder.platformBranchName
    /**
     * The category of platform version.
     */
    public val platformCategory: kotlin.String? = builder.platformCategory
    /**
     * The state of the platform version in its lifecycle.
     *
     * Possible values: `recommended` | empty
     *
     * If an empty value is returned, the platform version is supported but isn't the recommended one for its branch.
     */
    public val platformLifecycleState: kotlin.String? = builder.platformLifecycleState
    /**
     * The AWS account ID of the person who created the platform version.
     */
    public val platformOwner: kotlin.String? = builder.platformOwner
    /**
     * The status of the platform version. You can create an environment from the platform version once it is ready.
     */
    public val platformStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformStatus? = builder.platformStatus
    /**
     * The version string of the platform version.
     */
    public val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The additions associated with the platform version.
     */
    public val supportedAddonList: List<String>? = builder.supportedAddonList
    /**
     * The tiers in which the platform version runs.
     */
    public val supportedTierList: List<String>? = builder.supportedTierList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PlatformSummary(")
        append("operatingSystemName=$operatingSystemName,")
        append("operatingSystemVersion=$operatingSystemVersion,")
        append("platformArn=$platformArn,")
        append("platformBranchLifecycleState=$platformBranchLifecycleState,")
        append("platformBranchName=$platformBranchName,")
        append("platformCategory=$platformCategory,")
        append("platformLifecycleState=$platformLifecycleState,")
        append("platformOwner=$platformOwner,")
        append("platformStatus=$platformStatus,")
        append("platformVersion=$platformVersion,")
        append("supportedAddonList=$supportedAddonList,")
        append("supportedTierList=$supportedTierList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = operatingSystemName?.hashCode() ?: 0
        result = 31 * result + (operatingSystemVersion?.hashCode() ?: 0)
        result = 31 * result + (platformArn?.hashCode() ?: 0)
        result = 31 * result + (platformBranchLifecycleState?.hashCode() ?: 0)
        result = 31 * result + (platformBranchName?.hashCode() ?: 0)
        result = 31 * result + (platformCategory?.hashCode() ?: 0)
        result = 31 * result + (platformLifecycleState?.hashCode() ?: 0)
        result = 31 * result + (platformOwner?.hashCode() ?: 0)
        result = 31 * result + (platformStatus?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (supportedAddonList?.hashCode() ?: 0)
        result = 31 * result + (supportedTierList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PlatformSummary

        if (operatingSystemName != other.operatingSystemName) return false
        if (operatingSystemVersion != other.operatingSystemVersion) return false
        if (platformArn != other.platformArn) return false
        if (platformBranchLifecycleState != other.platformBranchLifecycleState) return false
        if (platformBranchName != other.platformBranchName) return false
        if (platformCategory != other.platformCategory) return false
        if (platformLifecycleState != other.platformLifecycleState) return false
        if (platformOwner != other.platformOwner) return false
        if (platformStatus != other.platformStatus) return false
        if (platformVersion != other.platformVersion) return false
        if (supportedAddonList != other.supportedAddonList) return false
        if (supportedTierList != other.supportedTierList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The operating system used by the platform version.
         */
        public var operatingSystemName: kotlin.String? = null
        /**
         * The version of the operating system used by the platform version.
         */
        public var operatingSystemVersion: kotlin.String? = null
        /**
         * The ARN of the platform version.
         */
        public var platformArn: kotlin.String? = null
        /**
         * The state of the platform version's branch in its lifecycle.
         *
         * Possible values: `beta` | `supported` | `deprecated` | `retired`
         */
        public var platformBranchLifecycleState: kotlin.String? = null
        /**
         * The platform branch to which the platform version belongs.
         */
        public var platformBranchName: kotlin.String? = null
        /**
         * The category of platform version.
         */
        public var platformCategory: kotlin.String? = null
        /**
         * The state of the platform version in its lifecycle.
         *
         * Possible values: `recommended` | empty
         *
         * If an empty value is returned, the platform version is supported but isn't the recommended one for its branch.
         */
        public var platformLifecycleState: kotlin.String? = null
        /**
         * The AWS account ID of the person who created the platform version.
         */
        public var platformOwner: kotlin.String? = null
        /**
         * The status of the platform version. You can create an environment from the platform version once it is ready.
         */
        public var platformStatus: aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformStatus? = null
        /**
         * The version string of the platform version.
         */
        public var platformVersion: kotlin.String? = null
        /**
         * The additions associated with the platform version.
         */
        public var supportedAddonList: List<String>? = null
        /**
         * The tiers in which the platform version runs.
         */
        public var supportedTierList: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformSummary) : this() {
            this.operatingSystemName = x.operatingSystemName
            this.operatingSystemVersion = x.operatingSystemVersion
            this.platformArn = x.platformArn
            this.platformBranchLifecycleState = x.platformBranchLifecycleState
            this.platformBranchName = x.platformBranchName
            this.platformCategory = x.platformCategory
            this.platformLifecycleState = x.platformLifecycleState
            this.platformOwner = x.platformOwner
            this.platformStatus = x.platformStatus
            this.platformVersion = x.platformVersion
            this.supportedAddonList = x.supportedAddonList
            this.supportedTierList = x.supportedTierList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformSummary = PlatformSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
