// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Health details for an AWS Elastic Beanstalk environment.
 */
public class DescribeEnvironmentHealthResponse private constructor(builder: Builder) {
    /**
     * Application request metrics for the environment.
     */
    public val applicationMetrics: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics? = builder.applicationMetrics
    /**
     * Descriptions of the data that contributed to the environment's current health status.
     */
    public val causes: List<String>? = builder.causes
    /**
     * The [health color](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html) of the environment.
     */
    public val color: kotlin.String? = builder.color
    /**
     * The environment's name.
     */
    public val environmentName: kotlin.String? = builder.environmentName
    /**
     * The [health status](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html) of the environment. For example, `Ok`.
     */
    public val healthStatus: kotlin.String? = builder.healthStatus
    /**
     * Summary health information for the instances in the environment.
     */
    public val instancesHealth: aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary? = builder.instancesHealth
    /**
     * The date and time that the health information was retrieved.
     */
    public val refreshedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.refreshedAt
    /**
     * The environment's operational status. `Ready`, `Launching`, `Updating`, `Terminating`, or `Terminated`.
     */
    public val status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeEnvironmentHealthResponse(")
        append("applicationMetrics=$applicationMetrics,")
        append("causes=$causes,")
        append("color=$color,")
        append("environmentName=$environmentName,")
        append("healthStatus=$healthStatus,")
        append("instancesHealth=$instancesHealth,")
        append("refreshedAt=$refreshedAt,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationMetrics?.hashCode() ?: 0
        result = 31 * result + (causes?.hashCode() ?: 0)
        result = 31 * result + (color?.hashCode() ?: 0)
        result = 31 * result + (environmentName?.hashCode() ?: 0)
        result = 31 * result + (healthStatus?.hashCode() ?: 0)
        result = 31 * result + (instancesHealth?.hashCode() ?: 0)
        result = 31 * result + (refreshedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeEnvironmentHealthResponse

        if (applicationMetrics != other.applicationMetrics) return false
        if (causes != other.causes) return false
        if (color != other.color) return false
        if (environmentName != other.environmentName) return false
        if (healthStatus != other.healthStatus) return false
        if (instancesHealth != other.instancesHealth) return false
        if (refreshedAt != other.refreshedAt) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Application request metrics for the environment.
         */
        public var applicationMetrics: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics? = null
        /**
         * Descriptions of the data that contributed to the environment's current health status.
         */
        public var causes: List<String>? = null
        /**
         * The [health color](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html) of the environment.
         */
        public var color: kotlin.String? = null
        /**
         * The environment's name.
         */
        public var environmentName: kotlin.String? = null
        /**
         * The [health status](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced-status.html) of the environment. For example, `Ok`.
         */
        public var healthStatus: kotlin.String? = null
        /**
         * Summary health information for the instances in the environment.
         */
        public var instancesHealth: aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary? = null
        /**
         * The date and time that the health information was retrieved.
         */
        public var refreshedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The environment's operational status. `Ready`, `Launching`, `Updating`, `Terminating`, or `Terminated`.
         */
        public var status: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse) : this() {
            this.applicationMetrics = x.applicationMetrics
            this.causes = x.causes
            this.color = x.color
            this.environmentName = x.environmentName
            this.healthStatus = x.healthStatus
            this.instancesHealth = x.instancesHealth
            this.refreshedAt = x.refreshedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse = DescribeEnvironmentHealthResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics] inside the given [block]
         */
        public fun applicationMetrics(block: aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics.Builder.() -> kotlin.Unit) {
            this.applicationMetrics = aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationMetrics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary] inside the given [block]
         */
        public fun instancesHealth(block: aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary.Builder.() -> kotlin.Unit) {
            this.instancesHealth = aws.sdk.kotlin.services.elasticbeanstalk.model.InstanceHealthSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
