// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentLink
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentResourcesDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateEnvironmentOperationDeserializer: HttpDeserializer.NonStreaming<UpdateEnvironmentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateEnvironmentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateEnvironmentError(context, call, payload)
        }
        val builder = UpdateEnvironmentResponse.Builder()

        if (payload != null) {
            deserializeUpdateEnvironmentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateEnvironmentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyBucketsException" -> TooManyBucketsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateEnvironmentOperationBody(builder: UpdateEnvironmentResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "UpdateEnvironment")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AbortableOperationInProgress com.amazonaws.elasticbeanstalk#EnvironmentDescription$AbortableOperationInProgress
            "AbortableOperationInProgress" -> builder.abortableOperationInProgress = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#EnvironmentDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // CNAME com.amazonaws.elasticbeanstalk#EnvironmentDescription$CNAME
            "CNAME" -> builder.cname = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#DNSCname`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // Description com.amazonaws.elasticbeanstalk#EnvironmentDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // EndpointURL com.amazonaws.elasticbeanstalk#EnvironmentDescription$EndpointURL
            "EndpointURL" -> builder.endpointUrl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EndpointURL`)" }
            // EnvironmentArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentArn
            "EnvironmentArn" -> builder.environmentArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentArn`)" }
            // EnvironmentId com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentId
            "EnvironmentId" -> builder.environmentId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentId`)" }
            // EnvironmentLinks com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentLinks
            "EnvironmentLinks" -> builder.environmentLinks = deserializeEnvironmentLinksShape(curr)
            // EnvironmentName com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // Health com.amazonaws.elasticbeanstalk#EnvironmentDescription$Health
            "Health" -> builder.health = curr.tryData()
                .parse { EnvironmentHealth.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentHealth`)" }
            // HealthStatus com.amazonaws.elasticbeanstalk#EnvironmentDescription$HealthStatus
            "HealthStatus" -> builder.healthStatus = curr.tryData()
                .parse { EnvironmentHealthStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentHealthStatus`)" }
            // OperationsRole com.amazonaws.elasticbeanstalk#EnvironmentDescription$OperationsRole
            "OperationsRole" -> builder.operationsRole = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OperationsRole`)" }
            // PlatformArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // Resources com.amazonaws.elasticbeanstalk#EnvironmentDescription$Resources
            "Resources" -> builder.resources = deserializeEnvironmentResourcesDescriptionDocument(curr)
            // SolutionStackName com.amazonaws.elasticbeanstalk#EnvironmentDescription$SolutionStackName
            "SolutionStackName" -> builder.solutionStackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#SolutionStackName`)" }
            // Status com.amazonaws.elasticbeanstalk#EnvironmentDescription$Status
            "Status" -> builder.status = curr.tryData()
                .parse { EnvironmentStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentStatus`)" }
            // TemplateName com.amazonaws.elasticbeanstalk#EnvironmentDescription$TemplateName
            "TemplateName" -> builder.templateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationTemplateName`)" }
            // Tier com.amazonaws.elasticbeanstalk#EnvironmentDescription$Tier
            "Tier" -> builder.tier = deserializeEnvironmentTierDocument(curr)
            // VersionLabel com.amazonaws.elasticbeanstalk#EnvironmentDescription$VersionLabel
            "VersionLabel" -> builder.versionLabel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#VersionLabel`)" }
            else -> {}
        }
        curr.drop()
    }
}
