// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A lifecycle rule that deletes application versions after the specified number of days.
 */
public class MaxAgeRule private constructor(builder: Builder) {
    /**
     * Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
     */
    public val deleteSourceFromS3: kotlin.Boolean? = builder.deleteSourceFromS3
    /**
     * Specify `true` to apply the rule, or `false` to disable it.
     */
    public val enabled: kotlin.Boolean = requireNotNull(builder.enabled) { "A non-null value must be provided for enabled" }
    /**
     * Specify the number of days to retain an application versions.
     */
    public val maxAgeInDays: kotlin.Int? = builder.maxAgeInDays

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaxAgeRule(")
        append("deleteSourceFromS3=$deleteSourceFromS3,")
        append("enabled=$enabled,")
        append("maxAgeInDays=$maxAgeInDays")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteSourceFromS3?.hashCode() ?: 0
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (maxAgeInDays ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaxAgeRule

        if (deleteSourceFromS3 != other.deleteSourceFromS3) return false
        if (enabled != other.enabled) return false
        if (maxAgeInDays != other.maxAgeInDays) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Set to `true` to delete a version's source bundle from Amazon S3 when Elastic Beanstalk deletes the application version.
         */
        public var deleteSourceFromS3: kotlin.Boolean? = null
        /**
         * Specify `true` to apply the rule, or `false` to disable it.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * Specify the number of days to retain an application versions.
         */
        public var maxAgeInDays: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule) : this() {
            this.deleteSourceFromS3 = x.deleteSourceFromS3
            this.enabled = x.enabled
            this.maxAgeInDays = x.maxAgeInDays
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.MaxAgeRule = MaxAgeRule(this)

        internal fun correctErrors(): Builder {
            if (enabled == null) enabled = false
            return this
        }
    }
}
