// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ActionStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.ActionType
import aws.sdk.kotlin.services.elasticbeanstalk.model.ManagedAction
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeManagedActionDocument(reader: XmlTagReader): ManagedAction {
    val builder = ManagedAction.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ActionId com.amazonaws.elasticbeanstalk#ManagedAction$ActionId
            "ActionId" -> builder.actionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // ActionDescription com.amazonaws.elasticbeanstalk#ManagedAction$ActionDescription
            "ActionDescription" -> builder.actionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // ActionType com.amazonaws.elasticbeanstalk#ManagedAction$ActionType
            "ActionType" -> builder.actionType = curr.tryData()
                .parse { ActionType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ActionType`)" }
            // Status com.amazonaws.elasticbeanstalk#ManagedAction$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ActionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ActionStatus`)" }
            // WindowStartTime com.amazonaws.elasticbeanstalk#ManagedAction$WindowStartTime
            "WindowStartTime" -> builder.windowStartTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#Timestamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
