// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the percentage of requests over the last 10 seconds that resulted in each type of status code response. For more information, see [Status Code Definitions](http://www.w3.org/Protocols/rfc2616/rfc2616-sec10.html).
 */
public class StatusCodes private constructor(builder: Builder) {
    /**
     * The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status code.
     */
    public val status2xx: kotlin.Int? = builder.status2xx
    /**
     * The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status code.
     */
    public val status3xx: kotlin.Int? = builder.status3xx
    /**
     * The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status code.
     */
    public val status4xx: kotlin.Int? = builder.status4xx
    /**
     * The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status code.
     */
    public val status5xx: kotlin.Int? = builder.status5xx

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatusCodes(")
        append("status2xx=$status2xx,")
        append("status3xx=$status3xx,")
        append("status4xx=$status4xx,")
        append("status5xx=$status5xx")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = status2xx ?: 0
        result = 31 * result + (status3xx ?: 0)
        result = 31 * result + (status4xx ?: 0)
        result = 31 * result + (status5xx ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatusCodes

        if (status2xx != other.status2xx) return false
        if (status3xx != other.status3xx) return false
        if (status4xx != other.status4xx) return false
        if (status5xx != other.status5xx) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The percentage of requests over the last 10 seconds that resulted in a 2xx (200, 201, etc.) status code.
         */
        public var status2xx: kotlin.Int? = null
        /**
         * The percentage of requests over the last 10 seconds that resulted in a 3xx (300, 301, etc.) status code.
         */
        public var status3xx: kotlin.Int? = null
        /**
         * The percentage of requests over the last 10 seconds that resulted in a 4xx (400, 401, etc.) status code.
         */
        public var status4xx: kotlin.Int? = null
        /**
         * The percentage of requests over the last 10 seconds that resulted in a 5xx (500, 501, etc.) status code.
         */
        public var status5xx: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes) : this() {
            this.status2xx = x.status2xx
            this.status3xx = x.status3xx
            this.status4xx = x.status4xx
            this.status5xx = x.status5xx
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.StatusCodes = StatusCodes(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
