// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateApplicationVersionOperationDeserializer: HttpDeserializer.NonStreaming<CreateApplicationVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateApplicationVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateApplicationVersionError(context, call, payload)
        }
        val builder = CreateApplicationVersionResponse.Builder()

        if (payload != null) {
            deserializeCreateApplicationVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateApplicationVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CodeBuildNotInServiceRegionException" -> CodeBuildNotInServiceRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "S3LocationNotInServiceRegionException" -> S3LocationNotInServiceRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyApplicationsException" -> TooManyApplicationsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyApplicationVersionsException" -> TooManyApplicationVersionsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateApplicationVersionOperationBody(builder: CreateApplicationVersionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateApplicationVersion")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationVersion com.amazonaws.elasticbeanstalk#ApplicationVersionDescriptionMessage$ApplicationVersion
            "ApplicationVersion" -> builder.applicationVersion = deserializeApplicationVersionDescriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
