// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListTagsForResourceOperationDeserializer: HttpDeserializer.NonStreaming<ListTagsForResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTagsForResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTagsForResourceError(context, call, payload)
        }
        val builder = ListTagsForResourceResponse.Builder()

        if (payload != null) {
            deserializeListTagsForResourceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTagsForResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceTypeNotSupportedException" -> ResourceTypeNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTagsForResourceOperationBody(builder: ListTagsForResourceResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListTagsForResource")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ResourceArn com.amazonaws.elasticbeanstalk#ResourceTagsDescriptionMessage$ResourceArn
            "ResourceArn" -> builder.resourceArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ResourceArn`)" }
            // ResourceTags com.amazonaws.elasticbeanstalk#ResourceTagsDescriptionMessage$ResourceTags
            "ResourceTags" -> builder.resourceTags = deserializeTagListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
