// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.BuildConfiguration
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.S3Location
import aws.sdk.kotlin.services.elasticbeanstalk.model.SourceBuildInformation
import aws.sdk.kotlin.services.elasticbeanstalk.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateApplicationVersionOperationSerializer: HttpSerializer.NonStreaming<CreateApplicationVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateApplicationVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCreateApplicationVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeCreateApplicationVersionOperationBody(context: ExecutionContext, input: CreateApplicationVersionRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ApplicationName"))
    val AUTOCREATEAPPLICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("AutoCreateApplication"))
    val BUILDCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("BuildConfiguration"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val PROCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Process"))
    val SOURCEBUILDINFORMATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("SourceBuildInformation"))
    val SOURCEBUNDLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("SourceBundle"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val VERSIONLABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("VersionLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateApplicationVersionMessage"))
        trait(QueryLiteral("Action", "CreateApplicationVersion"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(APPLICATIONNAME_DESCRIPTOR)
        field(AUTOCREATEAPPLICATION_DESCRIPTOR)
        field(BUILDCONFIGURATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(PROCESS_DESCRIPTOR)
        field(SOURCEBUILDINFORMATION_DESCRIPTOR)
        field(SOURCEBUNDLE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSIONLABEL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationName?.let { field(APPLICATIONNAME_DESCRIPTOR, it) }
        input.autoCreateApplication?.let { field(AUTOCREATEAPPLICATION_DESCRIPTOR, it) }
        input.buildConfiguration?.let { field(BUILDCONFIGURATION_DESCRIPTOR, it, ::serializeBuildConfigurationDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.process?.let { field(PROCESS_DESCRIPTOR, it) }
        input.sourceBuildInformation?.let { field(SOURCEBUILDINFORMATION_DESCRIPTOR, it, ::serializeSourceBuildInformationDocument) }
        input.sourceBundle?.let { field(SOURCEBUNDLE_DESCRIPTOR, it, ::serializeS3LocationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.versionLabel?.let { field(VERSIONLABEL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
