// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.SolutionStackDescription
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ListAvailableSolutionStacksOperationDeserializer: HttpDeserializer.NonStreaming<ListAvailableSolutionStacksResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListAvailableSolutionStacksResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListAvailableSolutionStacksError(context, call, payload)
        }
        val builder = ListAvailableSolutionStacksResponse.Builder()

        if (payload != null) {
            deserializeListAvailableSolutionStacksOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListAvailableSolutionStacksError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListAvailableSolutionStacksOperationBody(builder: ListAvailableSolutionStacksResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ListAvailableSolutionStacks")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // SolutionStackDetails com.amazonaws.elasticbeanstalk#ListAvailableSolutionStacksResultMessage$SolutionStackDetails
            "SolutionStackDetails" -> builder.solutionStackDetails = deserializeAvailableSolutionStackDetailsListShape(curr)
            // SolutionStacks com.amazonaws.elasticbeanstalk#ListAvailableSolutionStacksResultMessage$SolutionStacks
            "SolutionStacks" -> builder.solutionStacks = deserializeAvailableSolutionStackNamesListShape(curr)
            else -> {}
        }
        curr.drop()
    }
}
