// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationDescription
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeApplicationDescriptionDocument(reader: XmlTagReader): ApplicationDescription {
    val builder = ApplicationDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationArn com.amazonaws.elasticbeanstalk#ApplicationDescription$ApplicationArn
            "ApplicationArn" -> builder.applicationArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationArn`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#ApplicationDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // Description com.amazonaws.elasticbeanstalk#ApplicationDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#ApplicationDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#ApplicationDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // Versions com.amazonaws.elasticbeanstalk#ApplicationDescription$Versions
            "Versions" -> builder.versions = deserializeVersionLabelsListShape(curr)
            // ConfigurationTemplates com.amazonaws.elasticbeanstalk#ApplicationDescription$ConfigurationTemplates
            "ConfigurationTemplates" -> builder.configurationTemplates = deserializeConfigurationTemplateNamesListShape(curr)
            // ResourceLifecycleConfig com.amazonaws.elasticbeanstalk#ApplicationDescription$ResourceLifecycleConfig
            "ResourceLifecycleConfig" -> builder.resourceLifecycleConfig = deserializeApplicationResourceLifecycleConfigDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
