// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.EventDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.EventSeverity
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEventDescriptionDocument(reader: XmlTagReader): EventDescription {
    val builder = EventDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // EventDate com.amazonaws.elasticbeanstalk#EventDescription$EventDate
            "EventDate" -> builder.eventDate = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#EventDate`)" }
            // Message com.amazonaws.elasticbeanstalk#EventDescription$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EventMessage`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#EventDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // VersionLabel com.amazonaws.elasticbeanstalk#EventDescription$VersionLabel
            "VersionLabel" -> builder.versionLabel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#VersionLabel`)" }
            // TemplateName com.amazonaws.elasticbeanstalk#EventDescription$TemplateName
            "TemplateName" -> builder.templateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationTemplateName`)" }
            // EnvironmentName com.amazonaws.elasticbeanstalk#EventDescription$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // PlatformArn com.amazonaws.elasticbeanstalk#EventDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // RequestId com.amazonaws.elasticbeanstalk#EventDescription$RequestId
            "RequestId" -> builder.requestId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#RequestId`)" }
            // Severity com.amazonaws.elasticbeanstalk#EventDescription$Severity
            "Severity" -> builder.severity = curr.tryData()
                .parse { EventSeverity.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EventSeverity`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
