// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationDeploymentStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionSetting
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class UpdateConfigurationTemplateOperationDeserializer: HttpDeserializer.NonStreaming<UpdateConfigurationTemplateResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateConfigurationTemplateResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateConfigurationTemplateError(context, call, payload)
        }
        val builder = UpdateConfigurationTemplateResponse.Builder()

        if (payload != null) {
            deserializeUpdateConfigurationTemplateOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateConfigurationTemplateError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TooManyBucketsException" -> TooManyBucketsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateConfigurationTemplateOperationBody(builder: UpdateConfigurationTemplateResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "UpdateConfigurationTemplate")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // DeploymentStatus com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$DeploymentStatus
            "DeploymentStatus" -> builder.deploymentStatus = curr.tryData()
                .parse { ConfigurationDeploymentStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ConfigurationDeploymentStatus`)" }
            // Description com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // EnvironmentName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // OptionSettings com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$OptionSettings
            "OptionSettings" -> builder.optionSettings = deserializeConfigurationOptionSettingsListShape(curr)
            // PlatformArn com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // SolutionStackName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$SolutionStackName
            "SolutionStackName" -> builder.solutionStackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#SolutionStackName`)" }
            // TemplateName com.amazonaws.elasticbeanstalk#ConfigurationSettingsDescription$TemplateName
            "TemplateName" -> builder.templateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationTemplateName`)" }
            else -> {}
        }
        curr.drop()
    }
}
