// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.PlatformStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializePlatformDescriptionDocument(reader: XmlTagReader): PlatformDescription {
    val builder = PlatformDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // PlatformArn com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // PlatformOwner com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformOwner
            "PlatformOwner" -> builder.platformOwner = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformOwner`)" }
            // PlatformName com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformName
            "PlatformName" -> builder.platformName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformName`)" }
            // PlatformVersion com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformVersion
            "PlatformVersion" -> builder.platformVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformVersion`)" }
            // SolutionStackName com.amazonaws.elasticbeanstalk#PlatformDescription$SolutionStackName
            "SolutionStackName" -> builder.solutionStackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#SolutionStackName`)" }
            // PlatformStatus com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformStatus
            "PlatformStatus" -> builder.platformStatus = curr.tryData()
                .parse { PlatformStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#PlatformStatus`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#PlatformDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#PlatformDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // PlatformCategory com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformCategory
            "PlatformCategory" -> builder.platformCategory = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformCategory`)" }
            // Description com.amazonaws.elasticbeanstalk#PlatformDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // Maintainer com.amazonaws.elasticbeanstalk#PlatformDescription$Maintainer
            "Maintainer" -> builder.maintainer = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Maintainer`)" }
            // OperatingSystemName com.amazonaws.elasticbeanstalk#PlatformDescription$OperatingSystemName
            "OperatingSystemName" -> builder.operatingSystemName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OperatingSystemName`)" }
            // OperatingSystemVersion com.amazonaws.elasticbeanstalk#PlatformDescription$OperatingSystemVersion
            "OperatingSystemVersion" -> builder.operatingSystemVersion = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OperatingSystemVersion`)" }
            // ProgrammingLanguages com.amazonaws.elasticbeanstalk#PlatformDescription$ProgrammingLanguages
            "ProgrammingLanguages" -> builder.programmingLanguages = deserializePlatformProgrammingLanguagesShape(curr)
            // Frameworks com.amazonaws.elasticbeanstalk#PlatformDescription$Frameworks
            "Frameworks" -> builder.frameworks = deserializePlatformFrameworksShape(curr)
            // CustomAmiList com.amazonaws.elasticbeanstalk#PlatformDescription$CustomAmiList
            "CustomAmiList" -> builder.customAmiList = deserializeCustomAmiListShape(curr)
            // SupportedTierList com.amazonaws.elasticbeanstalk#PlatformDescription$SupportedTierList
            "SupportedTierList" -> builder.supportedTierList = deserializeSupportedTierListShape(curr)
            // SupportedAddonList com.amazonaws.elasticbeanstalk#PlatformDescription$SupportedAddonList
            "SupportedAddonList" -> builder.supportedAddonList = deserializeSupportedAddonListShape(curr)
            // PlatformLifecycleState com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformLifecycleState
            "PlatformLifecycleState" -> builder.platformLifecycleState = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformLifecycleState`)" }
            // PlatformBranchName com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformBranchName
            "PlatformBranchName" -> builder.platformBranchName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#BranchName`)" }
            // PlatformBranchLifecycleState com.amazonaws.elasticbeanstalk#PlatformDescription$PlatformBranchLifecycleState
            "PlatformBranchLifecycleState" -> builder.platformBranchLifecycleState = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformBranchLifecycleState`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
