// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.elasticbeanstalk.auth.DefaultElasticBeanstalkAuthSchemeProvider
import aws.sdk.kotlin.services.elasticbeanstalk.auth.ElasticBeanstalkAuthSchemeProvider
import aws.sdk.kotlin.services.elasticbeanstalk.endpoints.DefaultElasticBeanstalkEndpointProvider
import aws.sdk.kotlin.services.elasticbeanstalk.endpoints.ElasticBeanstalkEndpointParameters
import aws.sdk.kotlin.services.elasticbeanstalk.endpoints.ElasticBeanstalkEndpointProvider
import aws.sdk.kotlin.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.AbortEnvironmentUpdateResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.AssociateEnvironmentOperationsRoleResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CheckDnsAvailabilityRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ComposeEnvironmentsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateConfigurationTemplateResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreatePlatformVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreatePlatformVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateStorageLocationRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateStorageLocationResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteApplicationVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteConfigurationTemplateResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeletePlatformVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DeletePlatformVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeAccountAttributesRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeAccountAttributesResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationVersionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeApplicationsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationOptionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeConfigurationSettingsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentHealthResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEventsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeInstancesHealthResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribePlatformVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribePlatformVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.DisassociateEnvironmentOperationsRoleResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListAvailableSolutionStacksResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformBranchesResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformVersionsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListPlatformVersionsResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.RebuildEnvironmentRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.RebuildEnvironmentResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.RequestEnvironmentInfoResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.RestartAppServerRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.RestartAppServerResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.SwapEnvironmentCnamesRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.SwapEnvironmentCnamesResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.TerminateEnvironmentResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationVersionRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateConfigurationTemplateResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateEnvironmentResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateTagsForResourceRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateTagsForResourceResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest
import aws.sdk.kotlin.services.elasticbeanstalk.model.ValidateConfigurationSettingsResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Elastic Beanstalk"
public const val SdkVersion: String = "1.2.27"
public const val ServiceApiVersion: String = "2010-12-01"

/**
 * # AWS Elastic Beanstalk
 * AWS Elastic Beanstalk makes it easy for you to create, deploy, and manage scalable, fault-tolerant applications running on the Amazon Web Services cloud.
 *
 * For more information about this product, go to the [AWS Elastic Beanstalk](http://aws.amazon.com/elasticbeanstalk/) details page. The location of the latest AWS Elastic Beanstalk WSDL is [https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl](https://elasticbeanstalk.s3.amazonaws.com/doc/2010-12-01/AWSElasticBeanstalk.wsdl). To install the Software Development Kits (SDKs), Integrated Development Environment (IDE) Toolkits, and command line tools that enable you to access the API, go to [Tools for Amazon Web Services](http://aws.amazon.com/tools/).
 *
 * **Endpoints**
 *
 * For a list of region-specific endpoints that AWS Elastic Beanstalk supports, go to [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#elasticbeanstalk_region) in the *Amazon Web Services Glossary*.
 */
public interface ElasticBeanstalkClient : SdkClient {
    /**
     * ElasticBeanstalkClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ElasticBeanstalkClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ElasticBeanstalk",
                "ELASTIC_BEANSTALK",
                "elastic_beanstalk",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ElasticBeanstalkClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ElasticBeanstalkClient = DefaultElasticBeanstalkClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ElasticBeanstalkEndpointProvider = builder.endpointProvider ?: DefaultElasticBeanstalkEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ElasticBeanstalkAuthSchemeProvider = builder.authSchemeProvider ?: DefaultElasticBeanstalkAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Elastic Beanstalk"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ElasticBeanstalkEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ElasticBeanstalkAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Cancels in-progress environment configuration update or application version deployment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.AbortEnvironmentUpdate.sample
     */
    public suspend fun abortEnvironmentUpdate(input: AbortEnvironmentUpdateRequest = AbortEnvironmentUpdateRequest { }): AbortEnvironmentUpdateResponse

    /**
     * Applies a scheduled managed action immediately. A managed action can be applied only if its status is `Scheduled`. Get the status and action ID of a managed action with DescribeEnvironmentManagedActions.
     */
    public suspend fun applyEnvironmentManagedAction(input: ApplyEnvironmentManagedActionRequest): ApplyEnvironmentManagedActionResponse

    /**
     * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    public suspend fun associateEnvironmentOperationsRole(input: AssociateEnvironmentOperationsRoleRequest): AssociateEnvironmentOperationsRoleResponse

    /**
     * Checks if the specified CNAME is available.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CheckDNSAvailability.sample
     */
    public suspend fun checkDnsAvailability(input: CheckDnsAvailabilityRequest): CheckDnsAvailabilityResponse

    /**
     * Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named `env.yaml`. See [Compose Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html) for details.
     */
    public suspend fun composeEnvironments(input: ComposeEnvironmentsRequest = ComposeEnvironmentsRequest { }): ComposeEnvironmentsResponse

    /**
     * Creates an application that has one configuration template named `default` and no application versions.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateApplication.sample
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
     *
     * Specify a commit in an AWS CodeCommit repository with `SourceBuildInformation`.
     *
     * Specify a build in an AWS CodeBuild with `SourceBuildInformation` and `BuildConfiguration`.
     *
     * Specify a source bundle in S3 with `SourceBundle`
     *
     * Omit both `SourceBuildInformation` and `SourceBundle` to use the default sample application.
     *
     * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an environment from the application version.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateApplicationVersion.sample
     */
    public suspend fun createApplicationVersion(input: CreateApplicationVersionRequest): CreateApplicationVersionResponse

    /**
     * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings.
     *
     * Templates aren't associated with any environment. The `EnvironmentName` response element is always `null`.
     *
     * Related Topics
     * + DescribeConfigurationOptions
     * + DescribeConfigurationSettings
     * + ListAvailableSolutionStacks
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateConfigurationTemplate.sample
     */
    public suspend fun createConfigurationTemplate(input: CreateConfigurationTemplateRequest): CreateConfigurationTemplateResponse

    /**
     * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateEnvironment.sample
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Create a new version of your custom platform.
     */
    public suspend fun createPlatformVersion(input: CreatePlatformVersionRequest): CreatePlatformVersionResponse

    /**
     * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, `CreateStorageLocation` still returns the bucket name but does not create a new bucket.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateStorageLocation.sample
     */
    public suspend fun createStorageLocation(input: CreateStorageLocationRequest = CreateStorageLocationRequest { }): CreateStorageLocationResponse

    /**
     * Deletes the specified application along with all associated versions and configurations. The application versions will not be deleted from your Amazon S3 bucket.
     *
     * You cannot delete an application that has a running environment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteApplication.sample
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes the specified version from the specified application.
     *
     * You cannot delete an application version that is associated with a running environment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteApplicationVersion.sample
     */
    public suspend fun deleteApplicationVersion(input: DeleteApplicationVersionRequest): DeleteApplicationVersionResponse

    /**
     * Deletes the specified configuration template.
     *
     * When you launch an environment using a configuration template, the environment gets a copy of the template. You can delete or modify the environment's copy of the template without affecting the running environment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteConfigurationTemplate.sample
     */
    public suspend fun deleteConfigurationTemplate(input: DeleteConfigurationTemplateRequest): DeleteConfigurationTemplateResponse

    /**
     * Deletes the draft configuration associated with the running environment.
     *
     * Updating a running environment with any configuration changes creates a draft configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update fails. The `DeploymentStatus` for the draft configuration indicates whether the deployment is in process or has failed. The draft configuration remains in existence until it is deleted with this action.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteEnvironmentConfiguration.sample
     */
    public suspend fun deleteEnvironmentConfiguration(input: DeleteEnvironmentConfigurationRequest): DeleteEnvironmentConfigurationResponse

    /**
     * Deletes the specified version of a custom platform.
     */
    public suspend fun deletePlatformVersion(input: DeletePlatformVersionRequest = DeletePlatformVersionRequest { }): DeletePlatformVersionResponse

    /**
     * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
     *
     * The result currently has one set of attributes—resource quotas.
     */
    public suspend fun describeAccountAttributes(input: DescribeAccountAttributesRequest = DescribeAccountAttributesRequest { }): DescribeAccountAttributesResponse

    /**
     * Retrieve a list of application versions.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeApplicationVersions.sample
     */
    public suspend fun describeApplicationVersions(input: DescribeApplicationVersionsRequest = DescribeApplicationVersionsRequest { }): DescribeApplicationVersionsResponse

    /**
     * Returns the descriptions of existing applications.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeApplications.sample
     */
    public suspend fun describeApplications(input: DescribeApplicationsRequest = DescribeApplicationsRequest { }): DescribeApplicationsResponse

    /**
     * Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeConfigurationOptions.sample
     */
    public suspend fun describeConfigurationOptions(input: DescribeConfigurationOptionsRequest = DescribeConfigurationOptionsRequest { }): DescribeConfigurationOptionsResponse

    /**
     * Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.
     *
     * When describing the settings for the configuration set associated with a running environment, it is possible to receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft configuration of an environment that is either in the process of deployment or that failed to deploy.
     *
     * Related Topics
     * + DeleteEnvironmentConfiguration
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeConfigurationSettings.sample
     */
    public suspend fun describeConfigurationSettings(input: DescribeConfigurationSettingsRequest): DescribeConfigurationSettingsResponse

    /**
     * Returns information about the overall health of the specified environment. The **DescribeEnvironmentHealth** operation is only available with AWS Elastic Beanstalk Enhanced Health.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironmentHealth.sample
     */
    public suspend fun describeEnvironmentHealth(input: DescribeEnvironmentHealthRequest = DescribeEnvironmentHealthRequest { }): DescribeEnvironmentHealthResponse

    /**
     * Lists an environment's completed and failed managed actions.
     */
    public suspend fun describeEnvironmentManagedActionHistory(input: DescribeEnvironmentManagedActionHistoryRequest = DescribeEnvironmentManagedActionHistoryRequest { }): DescribeEnvironmentManagedActionHistoryResponse

    /**
     * Lists an environment's upcoming and in-progress managed actions.
     */
    public suspend fun describeEnvironmentManagedActions(input: DescribeEnvironmentManagedActionsRequest = DescribeEnvironmentManagedActionsRequest { }): DescribeEnvironmentManagedActionsResponse

    /**
     * Returns AWS resources for this environment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironmentResources.sample
     */
    public suspend fun describeEnvironmentResources(input: DescribeEnvironmentResourcesRequest = DescribeEnvironmentResourcesRequest { }): DescribeEnvironmentResourcesResponse

    /**
     * Returns descriptions for existing environments.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironments.sample
     */
    public suspend fun describeEnvironments(input: DescribeEnvironmentsRequest = DescribeEnvironmentsRequest { }): DescribeEnvironmentsResponse

    /**
     * Returns list of event descriptions matching criteria up to the last 6 weeks.
     *
     * This action returns the most recent 1,000 events from the specified `NextToken`.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEvents.sample
     */
    public suspend fun describeEvents(input: DescribeEventsRequest = DescribeEventsRequest { }): DescribeEventsResponse

    /**
     * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires [enhanced health reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeInstancesHealth.sample
     */
    public suspend fun describeInstancesHealth(input: DescribeInstancesHealthRequest = DescribeInstancesHealthRequest { }): DescribeInstancesHealthResponse

    /**
     * Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of platform versions.
     *
     * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    public suspend fun describePlatformVersion(input: DescribePlatformVersionRequest = DescribePlatformVersionRequest { }): DescribePlatformVersionResponse

    /**
     * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
     */
    public suspend fun disassociateEnvironmentOperationsRole(input: DisassociateEnvironmentOperationsRoleRequest): DisassociateEnvironmentOperationsRoleResponse

    /**
     * Returns a list of the available solution stack names, with the public version first and then in reverse chronological order.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.ListAvailableSolutionStacks.sample
     */
    public suspend fun listAvailableSolutionStacks(input: ListAvailableSolutionStacksRequest = ListAvailableSolutionStacksRequest { }): ListAvailableSolutionStacksResponse

    /**
     * Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.
     *
     * For definitions of platform branch and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    public suspend fun listPlatformBranches(input: ListPlatformBranchesRequest = ListPlatformBranchesRequest { }): ListPlatformBranchesResponse

    /**
     * Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform version.
     *
     * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
     */
    public suspend fun listPlatformVersions(input: ListPlatformVersionsRequest = ListPlatformVersionsRequest { }): ListPlatformVersionsResponse

    /**
     * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
     *
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RebuildEnvironment.sample
     */
    public suspend fun rebuildEnvironment(input: RebuildEnvironmentRequest = RebuildEnvironmentRequest { }): RebuildEnvironmentResponse

    /**
     * Initiates a request to compile the specified type of information of the deployed environment.
     *
     *  Setting the `InfoType` to `tail` compiles the last lines from the application server log files of every Amazon EC2 instance in your environment.
     *
     *  Setting the `InfoType` to `bundle` compresses the application server log files for every Amazon EC2 instance into a `.zip` file. Legacy and .NET containers do not support bundle logs.
     *
     *  Use RetrieveEnvironmentInfo to obtain the set of logs.
     *
     * Related Topics
     * + RetrieveEnvironmentInfo
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RequestEnvironmentInfo.sample
     */
    public suspend fun requestEnvironmentInfo(input: RequestEnvironmentInfoRequest): RequestEnvironmentInfoResponse

    /**
     * Causes the environment to restart the application container server running on each Amazon EC2 instance.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RestartAppServer.sample
     */
    public suspend fun restartAppServer(input: RestartAppServerRequest = RestartAppServerRequest { }): RestartAppServerResponse

    /**
     * Retrieves the compiled information from a RequestEnvironmentInfo request.
     *
     * Related Topics
     * + RequestEnvironmentInfo
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RetrieveEnvironmentInfo.sample
     */
    public suspend fun retrieveEnvironmentInfo(input: RetrieveEnvironmentInfoRequest): RetrieveEnvironmentInfoResponse

    /**
     * Swaps the CNAMEs of two environments.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.SwapEnvironmentCNAMEs.sample
     */
    public suspend fun swapEnvironmentCnames(input: SwapEnvironmentCnamesRequest = SwapEnvironmentCnamesRequest { }): SwapEnvironmentCnamesResponse

    /**
     * Terminates the specified environment.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.TerminateEnvironment.sample
     */
    public suspend fun terminateEnvironment(input: TerminateEnvironmentRequest = TerminateEnvironmentRequest { }): TerminateEnvironmentResponse

    /**
     * Updates the specified application to have the specified properties.
     *
     * If a property (for example, `description`) is not provided, the value remains unchanged. To clear these properties, specify an empty string.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateApplication.sample
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse

    /**
     * Modifies lifecycle settings for an application.
     */
    public suspend fun updateApplicationResourceLifecycle(input: UpdateApplicationResourceLifecycleRequest): UpdateApplicationResourceLifecycleResponse

    /**
     * Updates the specified application version to have the specified properties.
     *
     * If a property (for example, `description`) is not provided, the value remains unchanged. To clear properties, specify an empty string.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateApplicationVersion.sample
     */
    public suspend fun updateApplicationVersion(input: UpdateApplicationVersionRequest): UpdateApplicationVersionResponse

    /**
     * Updates the specified configuration template to have the specified properties or configuration option values.
     *
     * If a property (for example, `ApplicationName`) is not provided, its value remains unchanged. To clear such properties, specify an empty string.
     *
     * Related Topics
     * + DescribeConfigurationOptions
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateConfigurationTemplate.sample
     */
    public suspend fun updateConfigurationTemplate(input: UpdateConfigurationTemplateRequest): UpdateConfigurationTemplateResponse

    /**
     * Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.
     *
     *  Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an `InvalidParameterCombination` error.
     *
     *  When updating the configuration settings to a new template or individual settings, a draft configuration is created and DescribeConfigurationSettings for this environment returns two setting descriptions with different `DeploymentStatus` values.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateEnvironment.sample
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateEnvironment.sample2
     */
    public suspend fun updateEnvironment(input: UpdateEnvironmentRequest = UpdateEnvironmentRequest { }): UpdateEnvironmentResponse

    /**
     * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: `TagsToAdd` for tags to add or update, and `TagsToRemove`.
     *
     * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
     *
     * If you create a custom IAM user policy to control permission to this operation, specify one of the following two virtual actions (or both) instead of the API operation name:
     *
     * ## elasticbeanstalk:AddTags
     * Controls permission to call `UpdateTagsForResource` and pass a list of tags to add in the `TagsToAdd` parameter.
     *
     * ## elasticbeanstalk:RemoveTags
     * Controls permission to call `UpdateTagsForResource` and pass a list of tag keys to remove in the `TagsToRemove` parameter.
     *
     * For details about creating a custom user policy, see [Creating a Custom User Policy](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
     */
    public suspend fun updateTagsForResource(input: UpdateTagsForResourceRequest): UpdateTagsForResourceResponse

    /**
     * Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.
     *
     * This action returns a list of messages indicating any errors or warnings associated with the selection of option values.
     *
     * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.ValidateConfigurationSettings.sample
     */
    public suspend fun validateConfigurationSettings(input: ValidateConfigurationSettingsRequest): ValidateConfigurationSettingsResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ElasticBeanstalkClient.withConfig(block: ElasticBeanstalkClient.Config.Builder.() -> Unit): ElasticBeanstalkClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultElasticBeanstalkClient(newConfig)
}

/**
 * Cancels in-progress environment configuration update or application version deployment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.AbortEnvironmentUpdate.sample
 */
public suspend inline fun ElasticBeanstalkClient.abortEnvironmentUpdate(crossinline block: AbortEnvironmentUpdateRequest.Builder.() -> Unit): AbortEnvironmentUpdateResponse = abortEnvironmentUpdate(AbortEnvironmentUpdateRequest.Builder().apply(block).build())

/**
 * Applies a scheduled managed action immediately. A managed action can be applied only if its status is `Scheduled`. Get the status and action ID of a managed action with DescribeEnvironmentManagedActions.
 */
public suspend inline fun ElasticBeanstalkClient.applyEnvironmentManagedAction(crossinline block: ApplyEnvironmentManagedActionRequest.Builder.() -> Unit): ApplyEnvironmentManagedActionResponse = applyEnvironmentManagedAction(ApplyEnvironmentManagedActionRequest.Builder().apply(block).build())

/**
 * Add or change the operations role used by an environment. After this call is made, Elastic Beanstalk uses the associated operations role for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
 */
public suspend inline fun ElasticBeanstalkClient.associateEnvironmentOperationsRole(crossinline block: AssociateEnvironmentOperationsRoleRequest.Builder.() -> Unit): AssociateEnvironmentOperationsRoleResponse = associateEnvironmentOperationsRole(AssociateEnvironmentOperationsRoleRequest.Builder().apply(block).build())

/**
 * Checks if the specified CNAME is available.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CheckDNSAvailability.sample
 */
public suspend inline fun ElasticBeanstalkClient.checkDnsAvailability(crossinline block: CheckDnsAvailabilityRequest.Builder.() -> Unit): CheckDnsAvailabilityResponse = checkDnsAvailability(CheckDnsAvailabilityRequest.Builder().apply(block).build())

/**
 * Create or update a group of environments that each run a separate component of a single application. Takes a list of version labels that specify application source bundles for each of the environments to create or update. The name of each environment and other required information must be included in the source bundles in an environment manifest named `env.yaml`. See [Compose Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html) for details.
 */
public suspend inline fun ElasticBeanstalkClient.composeEnvironments(crossinline block: ComposeEnvironmentsRequest.Builder.() -> Unit): ComposeEnvironmentsResponse = composeEnvironments(ComposeEnvironmentsRequest.Builder().apply(block).build())

/**
 * Creates an application that has one configuration template named `default` and no application versions.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateApplication.sample
 */
public suspend inline fun ElasticBeanstalkClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates an application version for the specified application. You can create an application version from a source bundle in Amazon S3, a commit in AWS CodeCommit, or the output of an AWS CodeBuild build as follows:
 *
 * Specify a commit in an AWS CodeCommit repository with `SourceBuildInformation`.
 *
 * Specify a build in an AWS CodeBuild with `SourceBuildInformation` and `BuildConfiguration`.
 *
 * Specify a source bundle in S3 with `SourceBundle`
 *
 * Omit both `SourceBuildInformation` and `SourceBundle` to use the default sample application.
 *
 * After you create an application version with a specified Amazon S3 bucket and key location, you can't change that Amazon S3 location. If you change the Amazon S3 location, you receive an exception when you attempt to launch an environment from the application version.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateApplicationVersion.sample
 */
public suspend inline fun ElasticBeanstalkClient.createApplicationVersion(crossinline block: CreateApplicationVersionRequest.Builder.() -> Unit): CreateApplicationVersionResponse = createApplicationVersion(CreateApplicationVersionRequest.Builder().apply(block).build())

/**
 * Creates an AWS Elastic Beanstalk configuration template, associated with a specific Elastic Beanstalk application. You define application configuration settings in a configuration template. You can then use the configuration template to deploy different versions of the application with the same configuration settings.
 *
 * Templates aren't associated with any environment. The `EnvironmentName` response element is always `null`.
 *
 * Related Topics
 * + DescribeConfigurationOptions
 * + DescribeConfigurationSettings
 * + ListAvailableSolutionStacks
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateConfigurationTemplate.sample
 */
public suspend inline fun ElasticBeanstalkClient.createConfigurationTemplate(crossinline block: CreateConfigurationTemplateRequest.Builder.() -> Unit): CreateConfigurationTemplateResponse = createConfigurationTemplate(CreateConfigurationTemplateRequest.Builder().apply(block).build())

/**
 * Launches an AWS Elastic Beanstalk environment for the specified application using the specified configuration.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateEnvironment.sample
 */
public suspend inline fun ElasticBeanstalkClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Create a new version of your custom platform.
 */
public suspend inline fun ElasticBeanstalkClient.createPlatformVersion(crossinline block: CreatePlatformVersionRequest.Builder.() -> Unit): CreatePlatformVersionResponse = createPlatformVersion(CreatePlatformVersionRequest.Builder().apply(block).build())

/**
 * Creates a bucket in Amazon S3 to store application versions, logs, and other files used by Elastic Beanstalk environments. The Elastic Beanstalk console and EB CLI call this API the first time you create an environment in a region. If the storage location already exists, `CreateStorageLocation` still returns the bucket name but does not create a new bucket.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.CreateStorageLocation.sample
 */
public suspend inline fun ElasticBeanstalkClient.createStorageLocation(crossinline block: CreateStorageLocationRequest.Builder.() -> Unit): CreateStorageLocationResponse = createStorageLocation(CreateStorageLocationRequest.Builder().apply(block).build())

/**
 * Deletes the specified application along with all associated versions and configurations. The application versions will not be deleted from your Amazon S3 bucket.
 *
 * You cannot delete an application that has a running environment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteApplication.sample
 */
public suspend inline fun ElasticBeanstalkClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes the specified version from the specified application.
 *
 * You cannot delete an application version that is associated with a running environment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteApplicationVersion.sample
 */
public suspend inline fun ElasticBeanstalkClient.deleteApplicationVersion(crossinline block: DeleteApplicationVersionRequest.Builder.() -> Unit): DeleteApplicationVersionResponse = deleteApplicationVersion(DeleteApplicationVersionRequest.Builder().apply(block).build())

/**
 * Deletes the specified configuration template.
 *
 * When you launch an environment using a configuration template, the environment gets a copy of the template. You can delete or modify the environment's copy of the template without affecting the running environment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteConfigurationTemplate.sample
 */
public suspend inline fun ElasticBeanstalkClient.deleteConfigurationTemplate(crossinline block: DeleteConfigurationTemplateRequest.Builder.() -> Unit): DeleteConfigurationTemplateResponse = deleteConfigurationTemplate(DeleteConfigurationTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the draft configuration associated with the running environment.
 *
 * Updating a running environment with any configuration changes creates a draft configuration set. You can get the draft configuration using DescribeConfigurationSettings while the update is in progress or if the update fails. The `DeploymentStatus` for the draft configuration indicates whether the deployment is in process or has failed. The draft configuration remains in existence until it is deleted with this action.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DeleteEnvironmentConfiguration.sample
 */
public suspend inline fun ElasticBeanstalkClient.deleteEnvironmentConfiguration(crossinline block: DeleteEnvironmentConfigurationRequest.Builder.() -> Unit): DeleteEnvironmentConfigurationResponse = deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified version of a custom platform.
 */
public suspend inline fun ElasticBeanstalkClient.deletePlatformVersion(crossinline block: DeletePlatformVersionRequest.Builder.() -> Unit): DeletePlatformVersionResponse = deletePlatformVersion(DeletePlatformVersionRequest.Builder().apply(block).build())

/**
 * Returns attributes related to AWS Elastic Beanstalk that are associated with the calling AWS account.
 *
 * The result currently has one set of attributes—resource quotas.
 */
public suspend inline fun ElasticBeanstalkClient.describeAccountAttributes(crossinline block: DescribeAccountAttributesRequest.Builder.() -> Unit): DescribeAccountAttributesResponse = describeAccountAttributes(DescribeAccountAttributesRequest.Builder().apply(block).build())

/**
 * Retrieve a list of application versions.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeApplicationVersions.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeApplicationVersions(crossinline block: DescribeApplicationVersionsRequest.Builder.() -> Unit): DescribeApplicationVersionsResponse = describeApplicationVersions(DescribeApplicationVersionsRequest.Builder().apply(block).build())

/**
 * Returns the descriptions of existing applications.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeApplications.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeApplications(crossinline block: DescribeApplicationsRequest.Builder.() -> Unit): DescribeApplicationsResponse = describeApplications(DescribeApplicationsRequest.Builder().apply(block).build())

/**
 * Describes the configuration options that are used in a particular configuration template or environment, or that a specified solution stack defines. The description includes the values the options, their default values, and an indication of the required action on a running environment if an option value is changed.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeConfigurationOptions.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeConfigurationOptions(crossinline block: DescribeConfigurationOptionsRequest.Builder.() -> Unit): DescribeConfigurationOptionsResponse = describeConfigurationOptions(DescribeConfigurationOptionsRequest.Builder().apply(block).build())

/**
 * Returns a description of the settings for the specified configuration set, that is, either a configuration template or the configuration set associated with a running environment.
 *
 * When describing the settings for the configuration set associated with a running environment, it is possible to receive two sets of setting descriptions. One is the deployed configuration set, and the other is a draft configuration of an environment that is either in the process of deployment or that failed to deploy.
 *
 * Related Topics
 * + DeleteEnvironmentConfiguration
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeConfigurationSettings.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeConfigurationSettings(crossinline block: DescribeConfigurationSettingsRequest.Builder.() -> Unit): DescribeConfigurationSettingsResponse = describeConfigurationSettings(DescribeConfigurationSettingsRequest.Builder().apply(block).build())

/**
 * Returns information about the overall health of the specified environment. The **DescribeEnvironmentHealth** operation is only available with AWS Elastic Beanstalk Enhanced Health.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironmentHealth.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeEnvironmentHealth(crossinline block: DescribeEnvironmentHealthRequest.Builder.() -> Unit): DescribeEnvironmentHealthResponse = describeEnvironmentHealth(DescribeEnvironmentHealthRequest.Builder().apply(block).build())

/**
 * Lists an environment's completed and failed managed actions.
 */
public suspend inline fun ElasticBeanstalkClient.describeEnvironmentManagedActionHistory(crossinline block: DescribeEnvironmentManagedActionHistoryRequest.Builder.() -> Unit): DescribeEnvironmentManagedActionHistoryResponse = describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryRequest.Builder().apply(block).build())

/**
 * Lists an environment's upcoming and in-progress managed actions.
 */
public suspend inline fun ElasticBeanstalkClient.describeEnvironmentManagedActions(crossinline block: DescribeEnvironmentManagedActionsRequest.Builder.() -> Unit): DescribeEnvironmentManagedActionsResponse = describeEnvironmentManagedActions(DescribeEnvironmentManagedActionsRequest.Builder().apply(block).build())

/**
 * Returns AWS resources for this environment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironmentResources.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeEnvironmentResources(crossinline block: DescribeEnvironmentResourcesRequest.Builder.() -> Unit): DescribeEnvironmentResourcesResponse = describeEnvironmentResources(DescribeEnvironmentResourcesRequest.Builder().apply(block).build())

/**
 * Returns descriptions for existing environments.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEnvironments.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeEnvironments(crossinline block: DescribeEnvironmentsRequest.Builder.() -> Unit): DescribeEnvironmentsResponse = describeEnvironments(DescribeEnvironmentsRequest.Builder().apply(block).build())

/**
 * Returns list of event descriptions matching criteria up to the last 6 weeks.
 *
 * This action returns the most recent 1,000 events from the specified `NextToken`.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeEvents.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeEvents(crossinline block: DescribeEventsRequest.Builder.() -> Unit): DescribeEventsResponse = describeEvents(DescribeEventsRequest.Builder().apply(block).build())

/**
 * Retrieves detailed information about the health of instances in your AWS Elastic Beanstalk. This operation requires [enhanced health reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.DescribeInstancesHealth.sample
 */
public suspend inline fun ElasticBeanstalkClient.describeInstancesHealth(crossinline block: DescribeInstancesHealthRequest.Builder.() -> Unit): DescribeInstancesHealthResponse = describeInstancesHealth(DescribeInstancesHealthRequest.Builder().apply(block).build())

/**
 * Describes a platform version. Provides full details. Compare to ListPlatformVersions, which provides summary information about a list of platform versions.
 *
 * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
 */
public suspend inline fun ElasticBeanstalkClient.describePlatformVersion(crossinline block: DescribePlatformVersionRequest.Builder.() -> Unit): DescribePlatformVersionResponse = describePlatformVersion(DescribePlatformVersionRequest.Builder().apply(block).build())

/**
 * Disassociate the operations role from an environment. After this call is made, Elastic Beanstalk uses the caller's permissions for permissions to downstream services during subsequent calls acting on this environment. For more information, see [Operations roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/iam-operationsrole.html) in the *AWS Elastic Beanstalk Developer Guide*.
 */
public suspend inline fun ElasticBeanstalkClient.disassociateEnvironmentOperationsRole(crossinline block: DisassociateEnvironmentOperationsRoleRequest.Builder.() -> Unit): DisassociateEnvironmentOperationsRoleResponse = disassociateEnvironmentOperationsRole(DisassociateEnvironmentOperationsRoleRequest.Builder().apply(block).build())

/**
 * Returns a list of the available solution stack names, with the public version first and then in reverse chronological order.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.ListAvailableSolutionStacks.sample
 */
public suspend inline fun ElasticBeanstalkClient.listAvailableSolutionStacks(crossinline block: ListAvailableSolutionStacksRequest.Builder.() -> Unit): ListAvailableSolutionStacksResponse = listAvailableSolutionStacks(ListAvailableSolutionStacksRequest.Builder().apply(block).build())

/**
 * Lists the platform branches available for your account in an AWS Region. Provides summary information about each platform branch.
 *
 * For definitions of platform branch and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
 */
public suspend inline fun ElasticBeanstalkClient.listPlatformBranches(crossinline block: ListPlatformBranchesRequest.Builder.() -> Unit): ListPlatformBranchesResponse = listPlatformBranches(ListPlatformBranchesRequest.Builder().apply(block).build())

/**
 * Lists the platform versions available for your account in an AWS Region. Provides summary information about each platform version. Compare to DescribePlatformVersion, which provides full details about a single platform version.
 *
 * For definitions of platform version and other platform-related terms, see [AWS Elastic Beanstalk Platforms Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
 */
public suspend inline fun ElasticBeanstalkClient.listPlatformVersions(crossinline block: ListPlatformVersionsRequest.Builder.() -> Unit): ListPlatformVersionsResponse = listPlatformVersions(ListPlatformVersionsRequest.Builder().apply(block).build())

/**
 * Return the tags applied to an AWS Elastic Beanstalk resource. The response contains a list of tag key-value pairs.
 *
 * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
 */
public suspend inline fun ElasticBeanstalkClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Deletes and recreates all of the AWS resources (for example: the Auto Scaling group, load balancer, etc.) for a specified environment and forces a restart.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RebuildEnvironment.sample
 */
public suspend inline fun ElasticBeanstalkClient.rebuildEnvironment(crossinline block: RebuildEnvironmentRequest.Builder.() -> Unit): RebuildEnvironmentResponse = rebuildEnvironment(RebuildEnvironmentRequest.Builder().apply(block).build())

/**
 * Initiates a request to compile the specified type of information of the deployed environment.
 *
 *  Setting the `InfoType` to `tail` compiles the last lines from the application server log files of every Amazon EC2 instance in your environment.
 *
 *  Setting the `InfoType` to `bundle` compresses the application server log files for every Amazon EC2 instance into a `.zip` file. Legacy and .NET containers do not support bundle logs.
 *
 *  Use RetrieveEnvironmentInfo to obtain the set of logs.
 *
 * Related Topics
 * + RetrieveEnvironmentInfo
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RequestEnvironmentInfo.sample
 */
public suspend inline fun ElasticBeanstalkClient.requestEnvironmentInfo(crossinline block: RequestEnvironmentInfoRequest.Builder.() -> Unit): RequestEnvironmentInfoResponse = requestEnvironmentInfo(RequestEnvironmentInfoRequest.Builder().apply(block).build())

/**
 * Causes the environment to restart the application container server running on each Amazon EC2 instance.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RestartAppServer.sample
 */
public suspend inline fun ElasticBeanstalkClient.restartAppServer(crossinline block: RestartAppServerRequest.Builder.() -> Unit): RestartAppServerResponse = restartAppServer(RestartAppServerRequest.Builder().apply(block).build())

/**
 * Retrieves the compiled information from a RequestEnvironmentInfo request.
 *
 * Related Topics
 * + RequestEnvironmentInfo
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.RetrieveEnvironmentInfo.sample
 */
public suspend inline fun ElasticBeanstalkClient.retrieveEnvironmentInfo(crossinline block: RetrieveEnvironmentInfoRequest.Builder.() -> Unit): RetrieveEnvironmentInfoResponse = retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest.Builder().apply(block).build())

/**
 * Swaps the CNAMEs of two environments.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.SwapEnvironmentCNAMEs.sample
 */
public suspend inline fun ElasticBeanstalkClient.swapEnvironmentCnames(crossinline block: SwapEnvironmentCnamesRequest.Builder.() -> Unit): SwapEnvironmentCnamesResponse = swapEnvironmentCnames(SwapEnvironmentCnamesRequest.Builder().apply(block).build())

/**
 * Terminates the specified environment.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.TerminateEnvironment.sample
 */
public suspend inline fun ElasticBeanstalkClient.terminateEnvironment(crossinline block: TerminateEnvironmentRequest.Builder.() -> Unit): TerminateEnvironmentResponse = terminateEnvironment(TerminateEnvironmentRequest.Builder().apply(block).build())

/**
 * Updates the specified application to have the specified properties.
 *
 * If a property (for example, `description`) is not provided, the value remains unchanged. To clear these properties, specify an empty string.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateApplication.sample
 */
public suspend inline fun ElasticBeanstalkClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

/**
 * Modifies lifecycle settings for an application.
 */
public suspend inline fun ElasticBeanstalkClient.updateApplicationResourceLifecycle(crossinline block: UpdateApplicationResourceLifecycleRequest.Builder.() -> Unit): UpdateApplicationResourceLifecycleResponse = updateApplicationResourceLifecycle(UpdateApplicationResourceLifecycleRequest.Builder().apply(block).build())

/**
 * Updates the specified application version to have the specified properties.
 *
 * If a property (for example, `description`) is not provided, the value remains unchanged. To clear properties, specify an empty string.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateApplicationVersion.sample
 */
public suspend inline fun ElasticBeanstalkClient.updateApplicationVersion(crossinline block: UpdateApplicationVersionRequest.Builder.() -> Unit): UpdateApplicationVersionResponse = updateApplicationVersion(UpdateApplicationVersionRequest.Builder().apply(block).build())

/**
 * Updates the specified configuration template to have the specified properties or configuration option values.
 *
 * If a property (for example, `ApplicationName`) is not provided, its value remains unchanged. To clear such properties, specify an empty string.
 *
 * Related Topics
 * + DescribeConfigurationOptions
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateConfigurationTemplate.sample
 */
public suspend inline fun ElasticBeanstalkClient.updateConfigurationTemplate(crossinline block: UpdateConfigurationTemplateRequest.Builder.() -> Unit): UpdateConfigurationTemplateResponse = updateConfigurationTemplate(UpdateConfigurationTemplateRequest.Builder().apply(block).build())

/**
 * Updates the environment description, deploys a new application version, updates the configuration settings to an entirely new configuration template, or updates select configuration option values in the running environment.
 *
 *  Attempting to update both the release and configuration is not allowed and AWS Elastic Beanstalk returns an `InvalidParameterCombination` error.
 *
 *  When updating the configuration settings to a new template or individual settings, a draft configuration is created and DescribeConfigurationSettings for this environment returns two setting descriptions with different `DeploymentStatus` values.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateEnvironment.sample
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.UpdateEnvironment.sample2
 */
public suspend inline fun ElasticBeanstalkClient.updateEnvironment(crossinline block: UpdateEnvironmentRequest.Builder.() -> Unit): UpdateEnvironmentResponse = updateEnvironment(UpdateEnvironmentRequest.Builder().apply(block).build())

/**
 * Update the list of tags applied to an AWS Elastic Beanstalk resource. Two lists can be passed: `TagsToAdd` for tags to add or update, and `TagsToRemove`.
 *
 * Elastic Beanstalk supports tagging of all of its resources. For details about resource tagging, see [Tagging Application Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
 *
 * If you create a custom IAM user policy to control permission to this operation, specify one of the following two virtual actions (or both) instead of the API operation name:
 *
 * ## elasticbeanstalk:AddTags
 * Controls permission to call `UpdateTagsForResource` and pass a list of tags to add in the `TagsToAdd` parameter.
 *
 * ## elasticbeanstalk:RemoveTags
 * Controls permission to call `UpdateTagsForResource` and pass a list of tag keys to remove in the `TagsToRemove` parameter.
 *
 * For details about creating a custom user policy, see [Creating a Custom User Policy](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
 */
public suspend inline fun ElasticBeanstalkClient.updateTagsForResource(crossinline block: UpdateTagsForResourceRequest.Builder.() -> Unit): UpdateTagsForResourceResponse = updateTagsForResource(UpdateTagsForResourceRequest.Builder().apply(block).build())

/**
 * Takes a set of configuration settings and either a configuration template or environment, and determines whether those values are valid.
 *
 * This action returns a list of messages indicating any errors or warnings associated with the selection of option values.
 *
 * @sample aws.sdk.kotlin.services.elasticbeanstalk.samples.ValidateConfigurationSettings.sample
 */
public suspend inline fun ElasticBeanstalkClient.validateConfigurationSettings(crossinline block: ValidateConfigurationSettingsRequest.Builder.() -> Unit): ValidateConfigurationSettingsResponse = validateConfigurationSettings(ValidateConfigurationSettingsRequest.Builder().apply(block).build())
