// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ValidationMessage
import aws.sdk.kotlin.services.elasticbeanstalk.model.ValidationSeverity
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeValidationMessageDocument(reader: XmlTagReader): ValidationMessage {
    val builder = ValidationMessage.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Message com.amazonaws.elasticbeanstalk#ValidationMessage$Message
            "Message" -> builder.message = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ValidationMessageString`)" }
            // Severity com.amazonaws.elasticbeanstalk#ValidationMessage$Severity
            "Severity" -> builder.severity = curr.tryData()
                .parse { ValidationSeverity.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ValidationSeverity`)" }
            // Namespace com.amazonaws.elasticbeanstalk#ValidationMessage$Namespace
            "Namespace" -> builder.namespace = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OptionNamespace`)" }
            // OptionName com.amazonaws.elasticbeanstalk#ValidationMessage$OptionName
            "OptionName" -> builder.optionName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationOptionName`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
