// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.SingleInstanceHealth
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeSingleInstanceHealthDocument(reader: XmlTagReader): SingleInstanceHealth {
    val builder = SingleInstanceHealth.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // InstanceId com.amazonaws.elasticbeanstalk#SingleInstanceHealth$InstanceId
            "InstanceId" -> builder.instanceId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#InstanceId`)" }
            // HealthStatus com.amazonaws.elasticbeanstalk#SingleInstanceHealth$HealthStatus
            "HealthStatus" -> builder.healthStatus = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // Color com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Color
            "Color" -> builder.color = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // Causes com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Causes
            "Causes" -> builder.causes = deserializeCausesShape(curr)
            // LaunchedAt com.amazonaws.elasticbeanstalk#SingleInstanceHealth$LaunchedAt
            "LaunchedAt" -> builder.launchedAt = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#LaunchedAt`)" }
            // ApplicationMetrics com.amazonaws.elasticbeanstalk#SingleInstanceHealth$ApplicationMetrics
            "ApplicationMetrics" -> builder.applicationMetrics = deserializeApplicationMetricsDocument(curr)
            // System com.amazonaws.elasticbeanstalk#SingleInstanceHealth$System
            "System" -> builder.system = deserializeSystemStatusDocument(curr)
            // Deployment com.amazonaws.elasticbeanstalk#SingleInstanceHealth$Deployment
            "Deployment" -> builder.deployment = deserializeDeploymentDocument(curr)
            // AvailabilityZone com.amazonaws.elasticbeanstalk#SingleInstanceHealth$AvailabilityZone
            "AvailabilityZone" -> builder.availabilityZone = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // InstanceType com.amazonaws.elasticbeanstalk#SingleInstanceHealth$InstanceType
            "InstanceType" -> builder.instanceType = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
