// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealth
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentHealthStatus
import aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeEnvironmentDescriptionDocument(reader: XmlTagReader): EnvironmentDescription {
    val builder = EnvironmentDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // EnvironmentName com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentName
            "EnvironmentName" -> builder.environmentName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentName`)" }
            // EnvironmentId com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentId
            "EnvironmentId" -> builder.environmentId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentId`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#EnvironmentDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // VersionLabel com.amazonaws.elasticbeanstalk#EnvironmentDescription$VersionLabel
            "VersionLabel" -> builder.versionLabel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#VersionLabel`)" }
            // SolutionStackName com.amazonaws.elasticbeanstalk#EnvironmentDescription$SolutionStackName
            "SolutionStackName" -> builder.solutionStackName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#SolutionStackName`)" }
            // PlatformArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$PlatformArn
            "PlatformArn" -> builder.platformArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#PlatformArn`)" }
            // TemplateName com.amazonaws.elasticbeanstalk#EnvironmentDescription$TemplateName
            "TemplateName" -> builder.templateName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationTemplateName`)" }
            // Description com.amazonaws.elasticbeanstalk#EnvironmentDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // EndpointURL com.amazonaws.elasticbeanstalk#EnvironmentDescription$EndpointURL
            "EndpointURL" -> builder.endpointUrl = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EndpointURL`)" }
            // CNAME com.amazonaws.elasticbeanstalk#EnvironmentDescription$CNAME
            "CNAME" -> builder.cname = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#DNSCname`)" }
            // DateCreated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#EnvironmentDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // Status com.amazonaws.elasticbeanstalk#EnvironmentDescription$Status
            "Status" -> builder.status = curr.tryData()
                .parse { EnvironmentStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentStatus`)" }
            // AbortableOperationInProgress com.amazonaws.elasticbeanstalk#EnvironmentDescription$AbortableOperationInProgress
            "AbortableOperationInProgress" -> builder.abortableOperationInProgress = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticbeanstalk#AbortableOperationInProgress`)" }
            // Health com.amazonaws.elasticbeanstalk#EnvironmentDescription$Health
            "Health" -> builder.health = curr.tryData()
                .parse { EnvironmentHealth.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentHealth`)" }
            // HealthStatus com.amazonaws.elasticbeanstalk#EnvironmentDescription$HealthStatus
            "HealthStatus" -> builder.healthStatus = curr.tryData()
                .parse { EnvironmentHealthStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#EnvironmentHealthStatus`)" }
            // Resources com.amazonaws.elasticbeanstalk#EnvironmentDescription$Resources
            "Resources" -> builder.resources = deserializeEnvironmentResourcesDescriptionDocument(curr)
            // Tier com.amazonaws.elasticbeanstalk#EnvironmentDescription$Tier
            "Tier" -> builder.tier = deserializeEnvironmentTierDocument(curr)
            // EnvironmentLinks com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentLinks
            "EnvironmentLinks" -> builder.environmentLinks = deserializeEnvironmentLinksShape(curr)
            // EnvironmentArn com.amazonaws.elasticbeanstalk#EnvironmentDescription$EnvironmentArn
            "EnvironmentArn" -> builder.environmentArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#EnvironmentArn`)" }
            // OperationsRole com.amazonaws.elasticbeanstalk#EnvironmentDescription$OperationsRole
            "OperationsRole" -> builder.operationsRole = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OperationsRole`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
