// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.DescribeEnvironmentsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribeEnvironmentsOperationSerializer: HttpSerializer.NonStreaming<DescribeEnvironmentsRequest> {
    override fun serialize(context: ExecutionContext, input: DescribeEnvironmentsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeDescribeEnvironmentsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeDescribeEnvironmentsOperationBody(context: ExecutionContext, input: DescribeEnvironmentsRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ApplicationName"))
    val ENVIRONMENTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("EnvironmentIds"))
    val ENVIRONMENTNAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("EnvironmentNames"))
    val INCLUDEDELETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("IncludeDeleted"))
    val INCLUDEDDELETEDBACKTO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, FormUrlSerialName("IncludedDeletedBackTo"))
    val MAXRECORDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxRecords"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("NextToken"))
    val VERSIONLABEL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("VersionLabel"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("DescribeEnvironmentsMessage"))
        trait(QueryLiteral("Action", "DescribeEnvironments"))
        trait(QueryLiteral("Version", "2010-12-01"))
        field(APPLICATIONNAME_DESCRIPTOR)
        field(ENVIRONMENTIDS_DESCRIPTOR)
        field(ENVIRONMENTNAMES_DESCRIPTOR)
        field(INCLUDEDELETED_DESCRIPTOR)
        field(INCLUDEDDELETEDBACKTO_DESCRIPTOR)
        field(MAXRECORDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(VERSIONLABEL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.applicationName?.let { field(APPLICATIONNAME_DESCRIPTOR, it) }
        if (input.environmentIds != null) {
            listField(ENVIRONMENTIDS_DESCRIPTOR) {
                for (el0 in input.environmentIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.environmentNames != null) {
            listField(ENVIRONMENTNAMES_DESCRIPTOR) {
                for (el0 in input.environmentNames) {
                    serializeString(el0)
                }
            }
        }
        input.includeDeleted?.let { field(INCLUDEDELETED_DESCRIPTOR, it) }
        input.includedDeletedBackTo?.let { field(INCLUDEDDELETEDBACKTO_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        input.maxRecords?.let { field(MAXRECORDS_DESCRIPTOR, it) }
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        input.versionLabel?.let { field(VERSIONLABEL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
