// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.Deployment
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeDeploymentDocument(reader: XmlTagReader): Deployment {
    val builder = Deployment.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // VersionLabel com.amazonaws.elasticbeanstalk#Deployment$VersionLabel
            "VersionLabel" -> builder.versionLabel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // DeploymentId com.amazonaws.elasticbeanstalk#Deployment$DeploymentId
            "DeploymentId" -> builder.deploymentId = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.elasticbeanstalk#NullableLong`)" }
            // Status com.amazonaws.elasticbeanstalk#Deployment$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // DeploymentTime com.amazonaws.elasticbeanstalk#Deployment$DeploymentTime
            "DeploymentTime" -> builder.deploymentTime = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#DeploymentTimestamp`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
