// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionValueType
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeConfigurationOptionDescriptionDocument(reader: XmlTagReader): ConfigurationOptionDescription {
    val builder = ConfigurationOptionDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Namespace com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Namespace
            "Namespace" -> builder.namespace = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#OptionNamespace`)" }
            // Name com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Name
            "Name" -> builder.name = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationOptionName`)" }
            // DefaultValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$DefaultValue
            "DefaultValue" -> builder.defaultValue = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationOptionDefaultValue`)" }
            // ChangeSeverity com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ChangeSeverity
            "ChangeSeverity" -> builder.changeSeverity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ConfigurationOptionSeverity`)" }
            // UserDefined com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$UserDefined
            "UserDefined" -> builder.userDefined = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticbeanstalk#UserDefinedOption`)" }
            // ValueType com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ValueType
            "ValueType" -> builder.valueType = curr.tryData()
                .parse { ConfigurationOptionValueType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ConfigurationOptionValueType`)" }
            // ValueOptions com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$ValueOptions
            "ValueOptions" -> builder.valueOptions = deserializeConfigurationOptionPossibleValuesShape(curr)
            // MinValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MinValue
            "MinValue" -> builder.minValue = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMinValue`)" }
            // MaxValue com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MaxValue
            "MaxValue" -> builder.maxValue = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMaxValue`)" }
            // MaxLength com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$MaxLength
            "MaxLength" -> builder.maxLength = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.elasticbeanstalk#OptionRestrictionMaxLength`)" }
            // Regex com.amazonaws.elasticbeanstalk#ConfigurationOptionDescription$Regex
            "Regex" -> builder.regex = deserializeOptionRestrictionRegexDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
