// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ActionType
import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplyEnvironmentManagedActionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class ApplyEnvironmentManagedActionOperationDeserializer: HttpDeserializer.NonStreaming<ApplyEnvironmentManagedActionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ApplyEnvironmentManagedActionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwApplyEnvironmentManagedActionError(context, call, payload)
        }
        val builder = ApplyEnvironmentManagedActionResponse.Builder()

        if (payload != null) {
            deserializeApplyEnvironmentManagedActionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwApplyEnvironmentManagedActionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ManagedActionInvalidStateException" -> ManagedActionInvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ElasticBeanstalkServiceException" -> ElasticBeanstalkServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeApplyEnvironmentManagedActionOperationBody(builder: ApplyEnvironmentManagedActionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "ApplyEnvironmentManagedAction")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ActionDescription com.amazonaws.elasticbeanstalk#ApplyEnvironmentManagedActionResult$ActionDescription
            "ActionDescription" -> builder.actionDescription = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // ActionId com.amazonaws.elasticbeanstalk#ApplyEnvironmentManagedActionResult$ActionId
            "ActionId" -> builder.actionId = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // ActionType com.amazonaws.elasticbeanstalk#ApplyEnvironmentManagedActionResult$ActionType
            "ActionType" -> builder.actionType = curr.tryData()
                .parse { ActionType.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ActionType`)" }
            // Status com.amazonaws.elasticbeanstalk#ApplyEnvironmentManagedActionResult$Status
            "Status" -> builder.status = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            else -> {}
        }
        curr.drop()
    }
}
