// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionStatus
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeApplicationVersionDescriptionDocument(reader: XmlTagReader): ApplicationVersionDescription {
    val builder = ApplicationVersionDescription.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationVersionArn com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$ApplicationVersionArn
            "ApplicationVersionArn" -> builder.applicationVersionArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationVersionArn`)" }
            // ApplicationName com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // Description com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$Description
            "Description" -> builder.description = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#Description`)" }
            // VersionLabel com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$VersionLabel
            "VersionLabel" -> builder.versionLabel = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#VersionLabel`)" }
            // SourceBuildInformation com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$SourceBuildInformation
            "SourceBuildInformation" -> builder.sourceBuildInformation = deserializeSourceBuildInformationDocument(curr)
            // BuildArn com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$BuildArn
            "BuildArn" -> builder.buildArn = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#String`)" }
            // SourceBundle com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$SourceBundle
            "SourceBundle" -> builder.sourceBundle = deserializeS3LocationDocument(curr)
            // DateCreated com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$DateCreated
            "DateCreated" -> builder.dateCreated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#CreationDate`)" }
            // DateUpdated com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$DateUpdated
            "DateUpdated" -> builder.dateUpdated = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.elasticbeanstalk#UpdateDate`)" }
            // Status com.amazonaws.elasticbeanstalk#ApplicationVersionDescription$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ApplicationVersionStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.elasticbeanstalk#ApplicationVersionStatus`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
