// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the properties of an environment tier
 */
public class EnvironmentTier private constructor(builder: Builder) {
    /**
     * The name of this environment tier.
     *
     * Valid values:
     * + For *Web server tier* – `WebServer`
     * + For *Worker tier* – `Worker`
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of this environment tier.
     *
     * Valid values:
     * + For *Web server tier* – `Standard`
     * + For *Worker tier* – `SQS/HTTP`
     */
    public val type: kotlin.String? = builder.type
    /**
     * The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the latest compatible worker tier version.
     *
     * This member is deprecated. Any specific version that you set may become out of date. We recommend leaving it unspecified.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EnvironmentTier(")
        append("name=$name,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EnvironmentTier

        if (name != other.name) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of this environment tier.
         *
         * Valid values:
         * + For *Web server tier* – `WebServer`
         * + For *Worker tier* – `Worker`
         */
        public var name: kotlin.String? = null
        /**
         * The type of this environment tier.
         *
         * Valid values:
         * + For *Web server tier* – `Standard`
         * + For *Worker tier* – `SQS/HTTP`
         */
        public var type: kotlin.String? = null
        /**
         * The version of this environment tier. When you don't set a value to it, Elastic Beanstalk uses the latest compatible worker tier version.
         *
         * This member is deprecated. Any specific version that you set may become out of date. We recommend leaving it unspecified.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier) : this() {
            this.name = x.name
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.EnvironmentTier = EnvironmentTier(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
