// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.sdk.kotlin.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleResponse
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class UpdateApplicationResourceLifecycleOperationDeserializer: HttpDeserialize<UpdateApplicationResourceLifecycleResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateApplicationResourceLifecycleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApplicationResourceLifecycleError(context, call)
        }
        val builder = UpdateApplicationResourceLifecycleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApplicationResourceLifecycleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateApplicationResourceLifecycleError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApplicationResourceLifecycleOperationBody(builder: UpdateApplicationResourceLifecycleResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "UpdateApplicationResourceLifecycle")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationName com.amazonaws.elasticbeanstalk#ApplicationResourceLifecycleDescriptionMessage$ApplicationName
            "ApplicationName" -> builder.applicationName = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#ApplicationName`)" }
            // ResourceLifecycleConfig com.amazonaws.elasticbeanstalk#ApplicationResourceLifecycleDescriptionMessage$ResourceLifecycleConfig
            "ResourceLifecycleConfig" -> builder.resourceLifecycleConfig = deserializeApplicationResourceLifecycleConfigDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
