// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.DeleteApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteApplicationVersionOperationDeserializer: HttpDeserialize<DeleteApplicationVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteApplicationVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteApplicationVersionError(context, call)
        }
        val builder = DeleteApplicationVersionResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteApplicationVersionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall)
        "SourceBundleDeletionFailure" -> SourceBundleDeletionExceptionDeserializer().deserialize(context, wrappedCall)
        "OperationInProgressFailure" -> OperationInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        "S3LocationNotInServiceRegionException" -> S3LocationNotInServiceRegionExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
