// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.ApplicationVersionDescription
import aws.sdk.kotlin.services.elasticbeanstalk.model.CreateApplicationVersionResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CreateApplicationVersionOperationDeserializer: HttpDeserialize<CreateApplicationVersionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateApplicationVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateApplicationVersionError(context, call)
        }
        val builder = CreateApplicationVersionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateApplicationVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateApplicationVersionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InsufficientPrivilegesException" -> InsufficientPrivilegesExceptionDeserializer().deserialize(context, wrappedCall)
        "S3LocationNotInServiceRegionException" -> S3LocationNotInServiceRegionExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyApplicationsException" -> TooManyApplicationsExceptionDeserializer().deserialize(context, wrappedCall)
        "CodeBuildNotInServiceRegionException" -> CodeBuildNotInServiceRegionExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyApplicationVersionsException" -> TooManyApplicationVersionsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateApplicationVersionOperationBody(builder: CreateApplicationVersionResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CreateApplicationVersion")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // ApplicationVersion com.amazonaws.elasticbeanstalk#ApplicationVersionDescriptionMessage$ApplicationVersion
            "ApplicationVersion" -> builder.applicationVersion = deserializeApplicationVersionDescriptionDocument(curr)
            else -> {}
        }
        curr.drop()
    }
}
