// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.serde

import aws.sdk.kotlin.services.elasticbeanstalk.model.CheckDnsAvailabilityResponse
import aws.sdk.kotlin.services.elasticbeanstalk.model.ElasticBeanstalkException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseBoolean
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class CheckDNSAvailabilityOperationDeserializer: HttpDeserialize<CheckDnsAvailabilityResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CheckDnsAvailabilityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCheckDnsAvailabilityError(context, call)
        }
        val builder = CheckDnsAvailabilityResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCheckDNSAvailabilityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCheckDnsAvailabilityError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticBeanstalkException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        else -> ElasticBeanstalkException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCheckDNSAvailabilityOperationBody(builder: CheckDnsAvailabilityResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "CheckDNSAvailability")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // Available com.amazonaws.elasticbeanstalk#CheckDNSAvailabilityResultMessage$Available
            "Available" -> builder.available = curr.tryData()
                .parseBoolean()
                .getOrDeserializeErr { "expected (boolean: `com.amazonaws.elasticbeanstalk#CnameAvailability`)" }
            // FullyQualifiedCNAME com.amazonaws.elasticbeanstalk#CheckDNSAvailabilityResultMessage$FullyQualifiedCNAME
            "FullyQualifiedCNAME" -> builder.fullyQualifiedCname = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.elasticbeanstalk#DNSCname`)" }
            else -> {}
        }
        curr.drop()
    }
}
