// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticbeanstalk.model



/**
 * Describes the possible values for a configuration option.
 */
public class ConfigurationOptionDescription private constructor(builder: Builder) {
    /**
     * An indication of which action is required if the value for this configuration option changes:
     * + `NoInterruption` : There is no interruption to the environment or application availability.
     * + `RestartEnvironment` : The environment is entirely restarted, all AWS resources are deleted and recreated, and the environment is unavailable during the process.
     * + `RestartApplicationServer` : The environment is available the entire time. However, a short application outage occurs when the application servers on the running Amazon EC2 instances are restarted.
     */
    public val changeSeverity: kotlin.String? = builder.changeSeverity
    /**
     * The default value for this configuration option.
     */
    public val defaultValue: kotlin.String? = builder.defaultValue
    /**
     * If specified, the configuration option must be a string value no longer than this value.
     */
    public val maxLength: kotlin.Int? = builder.maxLength
    /**
     * If specified, the configuration option must be a numeric value less than this value.
     */
    public val maxValue: kotlin.Int? = builder.maxValue
    /**
     * If specified, the configuration option must be a numeric value greater than this value.
     */
    public val minValue: kotlin.Int? = builder.minValue
    /**
     * The name of the configuration option.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A unique namespace identifying the option's associated AWS resource.
     */
    public val namespace: kotlin.String? = builder.namespace
    /**
     * If specified, the configuration option must be a string value that satisfies this regular expression.
     */
    public val regex: aws.sdk.kotlin.services.elasticbeanstalk.model.OptionRestrictionRegex? = builder.regex
    /**
     * An indication of whether the user defined this configuration option:
     * + `true` : This configuration option was defined by the user. It is a valid choice for specifying if this as an `Option to Remove` when updating configuration settings.
     * + `false` : This configuration was not defined by the user.
     *
     *  Constraint: You can remove only `UserDefined` options from a configuration.
     *
     *  Valid Values: `true` | `false`
     */
    public val userDefined: kotlin.Boolean? = builder.userDefined
    /**
     * If specified, values for the configuration option are selected from this list.
     */
    public val valueOptions: List<String>? = builder.valueOptions
    /**
     * An indication of which type of values this option has and whether it is allowable to select one or more than one of the possible values:
     * + `Scalar` : Values for this option are a single selection from the possible values, or an unformatted string, or numeric value governed by the `MIN/MAX/Regex` constraints.
     * + `List` : Values for this option are multiple selections from the possible values.
     * + `Boolean` : Values for this option are either `true` or `false` .
     * + `Json` : Values for this option are a JSON representation of a `ConfigDocument`.
     */
    public val valueType: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionValueType? = builder.valueType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigurationOptionDescription(")
        append("changeSeverity=$changeSeverity,")
        append("defaultValue=$defaultValue,")
        append("maxLength=$maxLength,")
        append("maxValue=$maxValue,")
        append("minValue=$minValue,")
        append("name=$name,")
        append("namespace=$namespace,")
        append("regex=$regex,")
        append("userDefined=$userDefined,")
        append("valueOptions=$valueOptions,")
        append("valueType=$valueType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = changeSeverity?.hashCode() ?: 0
        result = 31 * result + (defaultValue?.hashCode() ?: 0)
        result = 31 * result + (maxLength ?: 0)
        result = 31 * result + (maxValue ?: 0)
        result = 31 * result + (minValue ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (namespace?.hashCode() ?: 0)
        result = 31 * result + (regex?.hashCode() ?: 0)
        result = 31 * result + (userDefined?.hashCode() ?: 0)
        result = 31 * result + (valueOptions?.hashCode() ?: 0)
        result = 31 * result + (valueType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigurationOptionDescription

        if (changeSeverity != other.changeSeverity) return false
        if (defaultValue != other.defaultValue) return false
        if (maxLength != other.maxLength) return false
        if (maxValue != other.maxValue) return false
        if (minValue != other.minValue) return false
        if (name != other.name) return false
        if (namespace != other.namespace) return false
        if (regex != other.regex) return false
        if (userDefined != other.userDefined) return false
        if (valueOptions != other.valueOptions) return false
        if (valueType != other.valueType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An indication of which action is required if the value for this configuration option changes:
         * + `NoInterruption` : There is no interruption to the environment or application availability.
         * + `RestartEnvironment` : The environment is entirely restarted, all AWS resources are deleted and recreated, and the environment is unavailable during the process.
         * + `RestartApplicationServer` : The environment is available the entire time. However, a short application outage occurs when the application servers on the running Amazon EC2 instances are restarted.
         */
        public var changeSeverity: kotlin.String? = null
        /**
         * The default value for this configuration option.
         */
        public var defaultValue: kotlin.String? = null
        /**
         * If specified, the configuration option must be a string value no longer than this value.
         */
        public var maxLength: kotlin.Int? = null
        /**
         * If specified, the configuration option must be a numeric value less than this value.
         */
        public var maxValue: kotlin.Int? = null
        /**
         * If specified, the configuration option must be a numeric value greater than this value.
         */
        public var minValue: kotlin.Int? = null
        /**
         * The name of the configuration option.
         */
        public var name: kotlin.String? = null
        /**
         * A unique namespace identifying the option's associated AWS resource.
         */
        public var namespace: kotlin.String? = null
        /**
         * If specified, the configuration option must be a string value that satisfies this regular expression.
         */
        public var regex: aws.sdk.kotlin.services.elasticbeanstalk.model.OptionRestrictionRegex? = null
        /**
         * An indication of whether the user defined this configuration option:
         * + `true` : This configuration option was defined by the user. It is a valid choice for specifying if this as an `Option to Remove` when updating configuration settings.
         * + `false` : This configuration was not defined by the user.
         *
         *  Constraint: You can remove only `UserDefined` options from a configuration.
         *
         *  Valid Values: `true` | `false`
         */
        public var userDefined: kotlin.Boolean? = null
        /**
         * If specified, values for the configuration option are selected from this list.
         */
        public var valueOptions: List<String>? = null
        /**
         * An indication of which type of values this option has and whether it is allowable to select one or more than one of the possible values:
         * + `Scalar` : Values for this option are a single selection from the possible values, or an unformatted string, or numeric value governed by the `MIN/MAX/Regex` constraints.
         * + `List` : Values for this option are multiple selections from the possible values.
         * + `Boolean` : Values for this option are either `true` or `false` .
         * + `Json` : Values for this option are a JSON representation of a `ConfigDocument`.
         */
        public var valueType: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionValueType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription) : this() {
            this.changeSeverity = x.changeSeverity
            this.defaultValue = x.defaultValue
            this.maxLength = x.maxLength
            this.maxValue = x.maxValue
            this.minValue = x.minValue
            this.name = x.name
            this.namespace = x.namespace
            this.regex = x.regex
            this.userDefined = x.userDefined
            this.valueOptions = x.valueOptions
            this.valueType = x.valueType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticbeanstalk.model.ConfigurationOptionDescription = ConfigurationOptionDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticbeanstalk.model.OptionRestrictionRegex] inside the given [block]
         */
        public fun regex(block: aws.sdk.kotlin.services.elasticbeanstalk.model.OptionRestrictionRegex.Builder.() -> kotlin.Unit) {
            this.regex = aws.sdk.kotlin.services.elasticbeanstalk.model.OptionRestrictionRegex.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
